%CALVING class definition
%
%   Usage:
%      calving=calving();

classdef calving
	properties (SetAccess=public) 
		stabilization = 0;
		calvingrate   = NaN;
		meltingrate   = NaN;
	end
	methods
		function obj = calving(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					inputstruct=varargin{1};
					list1 = properties('calving');
					list2 = fieldnames(inputstruct);
					for i=1:length(list1)
						fieldname = list1{i};
						if ismember(fieldname,list2),
							obj.(fieldname) = inputstruct.(fieldname);
						end
					end
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%stabilization = 2 by default
			obj.stabilization = 2;

		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{
			%Early return
			if (solution~=TransientSolutionEnum() | md.transient.iscalving==0), return; end

			md = checkfield(md,'fieldname','calving.stabilization','values',[0 1 2]);
			md = checkfield(md,'fieldname','calving.calvingrate(1:md.mesh.numberofvertices,:)','>=',0,'forcing',1,'NaN',1);
			md = checkfield(md,'fieldname','calving.meltingrate(1:md.mesh.numberofvertices,:)','>=',0,'forcing',1,'NaN',1);
		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   Calving parameters:'));
			fielddisplay(obj,'stabilization','0: no, 1: artificial_diffusivity, 2: streamline upwinding');
			fielddisplay(obj,'calvingrate','calving rate at given location [m/a]');
			fielddisplay(obj,'meltingrate','melting rate at given location [m/a]');
		end % }}}
		function marshall(obj,md,fid) % {{{
			yts=365.0*24.0*3600.0;
			WriteData(fid,'enum',CalvingLawEnum(),'data',DefaultCalvingEnum(),'format','Integer');
			WriteData(fid,'enum',LevelsetStabilizationEnum(),'data',obj.stabilization,'format','Integer');
			WriteData(fid,'object',obj,'fieldname','calvingrate','format','DoubleMat','mattype',1,'forcinglength',md.mesh.numberofvertices+1,'scale',1./yts);
			WriteData(fid,'object',obj,'fieldname','meltingrate','format','DoubleMat','mattype',1,'forcinglength',md.mesh.numberofvertices+1,'scale',1./yts);
		end % }}}
	end
end
