function results=thermal_core(models,inputs)
%THERMAL_CORE - core of thermal solution
%
%   Usage:
%      solution=thermal_core(models,inputs)

%get FE model
m_t=models.t;
m_m=models.m;

if m_t.parameters.dt==0,

	results.time=0;
	results.step=1;

	displaystring(m_t.parameters.debug,'\n%s',['computing temperatures...']);
	[results.t_g m_t.loads melting_offset]=thermal_core_nonlinear(m_t,inputs,ThermalAnalysisEnum(),NoneAnalysisEnum());

	displaystring(m_t.parameters.debug,'\n%s',['computing melting...']);
	inputs=add(inputs,'melting_offset',melting_offset,'double');
	inputs=add(inputs,'temperature',results.t_g,'doublevec',1,m_t.parameters.numberofnodes);
	results.m_g=diagnostic_core_linear(m_m,inputs,MeltingAnalysisEnum(),NoneAnalysisEnum());

else

	%initialize temperature and melting
	t_g=m_t.parameters.t_g;
	m_g=m_m.parameters.m_g;
	nsteps=m_t.parameters.ndt/m_t.parameters.dt;

	%initialize temperature and melting
	results.step=1;
	results.time=0;
	results.t_g=t_g;
	results.m_g=m_g;

	for n=1:nsteps, 

		displaystring(m_t.parameters.debug,'\n%s%i/%i\n','time step: ',n,nsteps);
		results(n+1).step=n+1;
		results(n+1).time=n*m_t.parameters.dt;

		displaystring(m_t.parameters.debug,'\n%s',['    computing temperatures...']);
		inputs=add(inputs,'temperature',results(n).t_g,'doublevec',1,m_t.parameters.numberofnodes);
		[results(n+1).t_g m_t.loads melting_offset]=thermal_core_nonlinear(m_t,inputs,ThermalAnalysisEnum(),NoneAnalysisEnum());

		displaystring(m_t.parameters.debug,'\n%s',['    computing melting...']);
		inputs=add(inputs,'temperature',results(n+1).t_g,'doublevec',1,m_t.parameters.numberofnodes);
		inputs=add(inputs,'melting_offset',melting_offset,'double');
		results(n+1).m_g=diagnostic_core_linear(m_m,inputs,MeltingAnalysisEnum(),NoneAnalysisEnum());

	end

end
