/*
 * \file EnumDefinitions.h:
 * \brief: enum functions for our objects
 */

#ifndef _ENUM_DEFINITIONS_
#define _ENUM_DEFINITIONS_

/*Datasets: */
int DatasetsEnum(void);
int ElementsEnum(void);
int NodesEnum(void);
int ConstraintsEnum(void);
int LoadsEnum(void);
int MaterialsEnum(void);
int ParametersEnum(void);
int ResultsEnum(void);

/*ANALYSIS TYPES: */
int AnalysisEnum(void);
//diagnostic
int DiagnosticAnalysisEnum(void);
int HorizAnalysisEnum(void);
int StokesAnalysisEnum(void);
int HutterAnalysisEnum(void);
int VertAnalysisEnum(void);
//control
int ControlAnalysisEnum(void);
int AdjointAnalysisEnum(void);
int InverseAnalysisEnum(void);
int GradientAnalysisEnum(void);
//thermal
int ThermalAnalysisEnum(void);
//transient
int TransientAnalysisEnum(void);
//slope
int SlopeComputeAnalysisEnum(void);
int SurfaceXAnalysisEnum(void);
int SurfaceYAnalysisEnum(void);
int BedXAnalysisEnum(void);
int BedYAnalysisEnum(void);
//prognostic
int PrognosticAnalysisEnum(void);
//melting
int MeltingAnalysisEnum(void);
//mesh2grid
int Mesh2gridAnalysisEnum(void);
//parameters
int ParametersAnalysisEnum(void);
//steadystate
int SteadystateAnalysisEnum(void);
//none
int NoneAnalysisEnum(void);


/*Formulations: */
int FormulationEnum(void);
int NoneFormulationEnum(void);
int HutterFormulationEnum(void);
int MacAyealFormulationEnum(void);
int PattynFormulationEnum(void);
int StokesFormulationEnum(void);

/*OBJECTS: */
int ObjectEnum(void);
/*Elements: */
int ElementEnum(void);
int TriaEnum(void);
int PentaEnum(void);
int SingEnum(void);
int BeamEnum(void);
/*Grids: */
int NodeEnum(void);
/*Loads: */
int LoadEnum(void);
int IcefrontEnum(void);
int RiftfrontEnum(void);
int PenpairEnum(void);
int PengridEnum(void);
/*Materials: */
int MaterialEnum(void);
int MaticeEnum(void);
int MatparEnum(void);
/*Inputs: */
int InputEnum(void);
/*Params: */
int ParamEnum(void);
/*Results: */
int ResultEnum(void);
/*Rgb: */
int RgbEnum(void);
/*Spc: */
int SpcEnum(void);

/*GEOGRAPHY:*/
int GeographyEnum(void);
int IceSheetEnum(void);
int IceShelfEnum(void);

/*FILL: */
int WaterEnum(void);
int IceEnum(void);
int AirEnum(void);
int MelangeEnum(void);

/*Functions on enums: */
int EnumIsElement(int en);
int EnumIsLoad(int en);
int EnumIsMaterial(int en);
#endif
