/*
 * \file EnumDefinitions.cpp:
 * \brief: enum functions for our objects
 */

#include "./EnumDefinitions.h"

/*Datasets: */
int DatasetsEnum(void){                 return          100; }
int ElementsEnum(void){                 return          101; }
int NodesEnum(void){                    return          102; }
int ConstraintsEnum(void){              return          103; }
int LoadsEnum(void){                    return          104; }
int MaterialsEnum(void){                return          105; }
int ParametersEnum(void){               return          106; }
int ResultsEnum(void){                  return          107; }

/*ANALYSIS TYPES: */
int AnalysisEnum(void){                 return          200; }
//diagnostic
int DiagnosticAnalysisEnum(void){       return          210; }
int HorizAnalysisEnum(void){            return          211; }
int StokesAnalysisEnum(void){           return          212; }
int HutterAnalysisEnum(void){           return          213; }
int VertAnalysisEnum(void){             return          214; }
//control
int ControlAnalysisEnum(void){          return          220; }
int AdjointAnalysisEnum(void){          return          221; }
int InverseAnalysisEnum(void){          return          222; }
int GradientAnalysisEnum(void){         return          223; }
//thermal
int ThermalAnalysisEnum(void){          return          230; }
//transient
int TransientAnalysisEnum(void){        return          231; }
//slope
int SlopeComputeAnalysisEnum(void){     return          240; }
int SurfaceXAnalysisEnum(void){         return          241; }
int SurfaceYAnalysisEnum(void){         return          242; }
int BedXAnalysisEnum(void){             return          243; }
int BedYAnalysisEnum(void){             return          244; }
//prognostic
int PrognosticAnalysisEnum(void){       return          250; }
//melting
int MeltingAnalysisEnum(void){          return          260; }
//mesh2grid
int Mesh2gridAnalysisEnum(void){        return          270; }
//parameters
int ParametersAnalysisEnum(void){       return          280; }
//steadystate
int SteadystateAnalysisEnum(void){      return          281; }
//none
int NoneAnalysisEnum(void){             return          290; }


/*Formulations: */
int FormulationEnum(void){              return          300; }
int NoneFormulationEnum(void){          return          301; }
int HutterFormulationEnum(void){        return          302; }
int MacAyealFormulationEnum(void){      return          303; }
int PattynFormulationEnum(void){        return          304; }
int StokesFormulationEnum(void){        return          305; }

/*OBJECTS: */
int ObjectEnum(void){                   return          400; }
/*Elements: */
int ElementEnum(void){                  return          410; }
int TriaEnum(void){                     return          411; }
int PentaEnum(void){                    return          412; }
int SingEnum(void){                     return          414; }
int BeamEnum(void){                     return          415; }
/*Grids: */
int NodeEnum(void){                     return          420; }
/*Loads: */
int LoadEnum(void){                     return          430; }
int IcefrontEnum(void){                 return          431; }
int RiftfrontEnum(void){                return          432; }
int PenpairEnum(void){                  return          433; }
int PengridEnum(void){                  return          434; }
/*Materials: */
int MaterialEnum(void){                 return          440; }
int MaticeEnum(void){                   return          441; }
int MatparEnum(void){                   return          442; }
/*Inputs: */
int InputEnum(void){                    return          450; }
/*Params: */
int ParamEnum(void){                    return          460; }
/*Results: */
int ResultEnum(void){                   return          470; }
/*Rgb: */
int RgbEnum(void){                      return          480; }
/*Spc: */
int SpcEnum(void){                      return          490; }

/*GEOGRAPHY:*/
int GeographyEnum(void){                return          500; }
int IceSheetEnum(void){                 return          502; }
int IceShelfEnum(void){                 return          502; }

/*FILL:*/
int WaterEnum(void){                    return          601; }
int IceEnum(void){                      return          602; }
int AirEnum(void){                      return          603; }
int MelangeEnum(void){                  return          604; }

/*functions on enums: */
int EnumIsElement(int en){
	if ((en>=410) && (en<=419))return 1;
	else return 0;
}

int EnumIsLoad(int en){
	if ((en>=430) && (en<=439))return 1;
	else return 0;
}
int EnumIsMaterial(int en){
	if ((en>=440) && (en<=449))return 1;
	else return 0;
}
