%CALVINGPI class definition
%
%   Usage:
%      calvingpi=calvingpi();

classdef calvingpi
	properties (SetAccess=public) 
		 coeff       = NaN;
		 meltingrate = NaN;
	end
	methods
		function obj = calvingpi(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					inputstruct=varargin{1};
					list1 = properties('calvingpi');
					list2 = fieldnames(inputstruct);
					for i=1:length(list1)
						fieldname = list1{i};
						if ismember(fieldname,list2),
							obj.(fieldname) = inputstruct.(fieldname);
						end
					end
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{
			%Proportionality coefficient in Pi model
			obj.coeff=2e13;
		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{
			%Early return
			if (solution~=TransientSolutionEnum() | md.transient.iscalving==0), return; end
			md = checkfield(md,'fieldname','calving.coeff','>',0,'size',[md.mesh.numberofvertices 1]);
			md = checkfield(md,'fieldname','calving.meltingrate','NaN',1,'size',[md.mesh.numberofvertices 1],'>=',0);
		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   Calving Pi parameters:'));
			fielddisplay(obj,'coeff','proportionality coefficient in Pi model');
			fielddisplay(obj,'meltingrate','melting rate at given location [m/a]');

		end % }}}
		function marshall(obj,md,fid) % {{{
			yts=365.0*24.0*3600.0;
			WriteData(fid,'enum',CalvingLawEnum(),'data',CalvingPiEnum(),'format','Integer');
			WriteData(fid,'enum',CalvingpiCoeffEnum(),'data',obj.coeff,'format','DoubleMat','mattype',1);
			WriteData(fid,'object',obj,'fieldname','meltingrate','format','DoubleMat','mattype',1,'forcinglength',md.mesh.numberofvertices+1,'scale',1./yts);
		end % }}}
	end
end
