from model import *
from triangle import *
from setmask import *
from parameterize import *
from setflowequation import *
from EnumDefinitions import *
from solve import *
from MatlabFuncs import *
from massfluxatgate import massfluxatgate
from generic import generic

md=triangle(model(),'../Exp/Square.exp',50000)
md=setmask(md,'all','')
md=parameterize(md,'../Par/SquareShelfConstrained.py')
md=setflowequation(md,'SSA','all')
md.cluster=generic('name',oshostname(),'np',3)

#outputs
md.stressbalance.requested_outputs=['default','DeviatoricStressxx','DeviatoricStressyy','DeviatoricStressxy','MassFlux1','MassFlux2','MassFlux3','MassFlux4','MassFlux5','MassFlux6']
md.outputdefinition.definitions=[
		massfluxatgate('name','MassFlux1','profilename','../Exp/MassFlux1.exp','definitionenum',Outputdefinition1Enum()),
		massfluxatgate('name','MassFlux2','profilename','../Exp/MassFlux2.exp','definitionenum',Outputdefinition2Enum()),
		massfluxatgate('name','MassFlux3','profilename','../Exp/MassFlux3.exp','definitionenum',Outputdefinition3Enum()),
		massfluxatgate('name','MassFlux4','profilename','../Exp/MassFlux4.exp','definitionenum',Outputdefinition4Enum()),
		massfluxatgate('name','MassFlux5','profilename','../Exp/MassFlux5.exp','definitionenum',Outputdefinition5Enum()),
		massfluxatgate('name','MassFlux6','profilename','../Exp/MassFlux6.exp','definitionenum',Outputdefinition6Enum())
		]

md=solve(md,StressbalanceSolutionEnum())

#Fields and tolerances to track changes
field_names     =['Vx','Vy','Vel','Pressure',\
	'DeviatoricStressxx','DeviatoricStressyy','DeviatoricStressxy','MassFlux1','MassFlux2','MassFlux3','MassFlux4','MassFlux5','MassFlux6']
field_tolerances=[1e-13,1e-13,1e-13,1e-13,\
	1e-13,1e-13,1e-13,\
	1e-13, 1e-13, 1e-13, 1e-13, 1e-13, 1e-13 ]
field_values=[\
	md.results.StressbalanceSolution.Vx,\
	md.results.StressbalanceSolution.Vy,\
	md.results.StressbalanceSolution.Vel,\
	md.results.StressbalanceSolution.Pressure,\
	md.results.StressbalanceSolution.DeviatoricStressxx,\
	md.results.StressbalanceSolution.DeviatoricStressyy,\
	md.results.StressbalanceSolution.DeviatoricStressxy,\
	md.results.StressbalanceSolution.MassFlux1,\
	md.results.StressbalanceSolution.MassFlux2,\
	md.results.StressbalanceSolution.MassFlux3,\
	md.results.StressbalanceSolution.MassFlux4,\
	md.results.StressbalanceSolution.MassFlux5,\
	md.results.StressbalanceSolution.MassFlux6 ]
