/*!\file: CreateParametersOutputDefinitions.cpp
 * \brief driver for creating output definitions dataset, and including it into the parameters dataset
 */ 

#include "../../toolkits/toolkits.h"
#include "../../classes/classes.h"
#include "../../shared/shared.h"
#include "./ModelProcessorx.h"

void CreateOutputDefinitions(Elements* elements, Parameters* parameters,IoModel* iomodel){

	int i,j;
	
	DataSet*     output_definitions      = NULL;
	int*         output_definition_enums = NULL;
	int          num_output_definitions;

	/*Create output_definitions dataset: */
	output_definitions=new DataSet();
	
	iomodel->FetchData(&output_definition_enums,&num_output_definitions,NULL,OutputdefinitionListEnum);
	if(num_output_definitions){
		for (i=0;i<num_output_definitions;i++){

			if (output_definition_enums[i]==MassfluxatgateEnum){

				/*Deal with mass flux gates:{{{ */
				
				/*massfluxatgate variables: */
				int          temp,numgates;
				char       **gatenames               = NULL;
				int        *gatedefinitionenums      = NULL;
				IssmDouble **gatesegments            = NULL;
				int         *gatesegments_M          = NULL;


				/*Fetch segments and names: */
				iomodel->FetchMultipleData(&gatenames,&numgates,MassfluxatgateNameEnum);
				iomodel->FetchMultipleData(&gatedefinitionenums,&temp,MassfluxatgateDefinitionenumEnum); _assert_(temp==numgates);
				iomodel->FetchMultipleData(&gatesegments,&gatesegments_M,NULL,&temp,MassfluxatgateSegmentsEnum);_assert_(temp==numgates); 

				for(j=0;j<numgates;j++){
					output_definitions->AddObject(new Massfluxatgate<IssmDouble>(gatenames[j],gatedefinitionenums[j],gatesegments_M[j],gatesegments[j]));
				}
				/*Free ressources:*/
				for(j=0;j<numgates;j++){
					char*       string = gatenames[j];    xDelete<char>(string);
					IssmDouble* gate   = gatesegments[j]; xDelete<IssmDouble>(gate);
				}
				xDelete<char*>(gatenames);
				xDelete<IssmDouble*>(gatesegments);
				xDelete<int>(gatesegments_M);
				xDelete<int>(gatedefinitionenums);
				/*}}}*/
			}
			else if (output_definition_enums[i]==MisfitEnum){
				/*Deal with misfits: {{{*/
				
				/*misfit variables: */
				int          nummisfits;
				char**       misfit_name_s             = NULL;    
				int*         misfit_definitionenums_s             = NULL;    
				int*         misfit_model_enum_s        = NULL;
				IssmDouble** misfit_observation_s      = NULL;
				int*         misfit_observation_enum_s  = NULL;
				int*         misfit_observation_M_s    = NULL;
				int*         misfit_observation_N_s    = NULL;
				char**       misfit_timeinterpolation_s = NULL;
				IssmDouble** misfit_weights_s           = NULL;
				int*         misfit_weights_M_s    = NULL;
				int*         misfit_weights_N_s    = NULL;
				int*         misfit_weights_enum_s= NULL;

				/*Fetch name, model_enum, observation, observation_enum, etc ... (see src/m/classes/misfit.m): */
				iomodel->FetchMultipleData(&misfit_name_s,&nummisfits,MisfitNameEnum);
				iomodel->FetchMultipleData(&misfit_definitionenums_s,&nummisfits,MisfitDefinitionenumEnum);
				iomodel->FetchMultipleData(&misfit_model_enum_s,&nummisfits,MisfitModelEnumEnum);
				iomodel->FetchMultipleData(&misfit_observation_s,&misfit_observation_M_s,&misfit_observation_N_s,&nummisfits,MisfitObservationEnum);
				iomodel->FetchMultipleData(&misfit_observation_enum_s,&nummisfits,MisfitObservationEnumEnum);
				iomodel->FetchMultipleData(&misfit_timeinterpolation_s,&nummisfits,MisfitTimeinterpolationEnum);
				iomodel->FetchMultipleData(&misfit_weights_s,&misfit_weights_M_s,&misfit_weights_N_s,&nummisfits,MisfitWeightsEnum);
				iomodel->FetchMultipleData(&misfit_weights_enum_s,&nummisfits,MisfitWeightsEnumEnum);

				for(j=0;j<nummisfits;j++){

					/*First create a misfit object for that specific enum (misfit_model_enum_s[j]):*/
					output_definitions->AddObject(new Misfit(misfit_name_s[j],misfit_definitionenums_s[j],misfit_model_enum_s[j],misfit_observation_enum_s[j],misfit_timeinterpolation_s[j],misfit_weights_enum_s[j]));

					/*Now, for this particular misfit object, make sure we plug into the elements: the observation, and the weights.*/
					for(i=0;i<elements->Size();i++){
						Element* element=xDynamicCast<Element*>(elements->GetObjectByOffset(i));
						element->InputCreate(misfit_observation_s[j], iomodel,misfit_observation_M_s[j],misfit_observation_N_s[j],1,misfit_observation_enum_s[j],7);
						element->InputCreate(misfit_weights_s[j], iomodel,misfit_weights_M_s[j],misfit_weights_N_s[j],1,misfit_weights_enum_s[j],7);
					}

				}

				/*Free ressources:*/
				for(j=0;j<nummisfits;j++){
					char* string=NULL;
					IssmDouble* matrix = NULL;

					string = misfit_name_s[j];    xDelete<char>(string);
					string = misfit_timeinterpolation_s[j];    xDelete<char>(string);
					matrix = misfit_observation_s[j]; xDelete<IssmDouble>(matrix);
					matrix = misfit_weights_s[j]; xDelete<IssmDouble>(matrix);
				}
				xDelete<char*>(misfit_name_s);
				xDelete<int>(misfit_model_enum_s);
				xDelete<IssmDouble*>(misfit_observation_s);
				xDelete<int>(misfit_observation_enum_s);
				xDelete<int>(misfit_observation_M_s);
				xDelete<int>(misfit_observation_N_s);
				xDelete<char*>(misfit_timeinterpolation_s);
				xDelete<IssmDouble*>(misfit_weights_s);
				xDelete<int>(misfit_weights_M_s);
				xDelete<int>(misfit_weights_N_s);
				xDelete<int>(misfit_weights_enum_s);
				/*}}}*/
			}
			else if (output_definition_enums[i]==MassconEnum){
				/*Deal with masscons: {{{*/
				
				/*masscon variables: */
				int          nummasscons;
				char**       masscon_name_s             = NULL;    
				int*         masscon_definitionenum_s   = NULL;    
				IssmDouble** masscon_levelset_s           = NULL;
				int*         masscon_levelset_M_s    = NULL;
				int*         masscon_levelset_N_s    = NULL;

				/*Fetch name and levelset, etc ... (see src/m/classes/masscon.m): */
				iomodel->FetchMultipleData(&masscon_name_s,&nummasscons,MassconNameEnum);
				iomodel->FetchMultipleData(&masscon_definitionenum_s,&nummasscons,MassconDefinitionenumEnum);
				iomodel->FetchMultipleData(&masscon_levelset_s,&masscon_levelset_M_s,&masscon_levelset_N_s,&nummasscons,MassconLevelsetEnum);
				for(j=0;j<nummasscons;j++){

					/*Create a masscon object: */
					output_definitions->AddObject(new Masscon(masscon_name_s[j],masscon_definitionenum_s[j],masscon_levelset_s[j],masscon_levelset_M_s[j]));

				}

				/*Free ressources:*/
				for(j=0;j<nummasscons;j++){
					char* string=NULL;
					IssmDouble* matrix = NULL;

					string = masscon_name_s[j];    xDelete<char>(string);
					matrix = masscon_levelset_s[j]; xDelete<IssmDouble>(matrix);
				}
				xDelete<char*>(masscon_name_s);
				xDelete<IssmDouble*>(masscon_levelset_s);
				xDelete<int>(masscon_levelset_M_s);
				xDelete<int>(masscon_levelset_N_s);
				xDelete<int>(masscon_definitionenum_s);
				/*}}}*/
			}
			else if (output_definition_enums[i]==MassconaxpbyEnum){
				/*Deal with masscon combinations: {{{*/
				
				/*masscon variables: */
				char**       masscon_name_s             = NULL;    
				int*         masscon_definitionenum_s             = NULL;    
				char**       masscon_namex_s             = NULL;    
				char**       masscon_namey_s             = NULL;    
				IssmDouble*  masscon_alpha_s     = NULL;
				IssmDouble*  masscon_beta_s     = NULL;
				int          num;

				/*Fetch names and multiplicators, etc ... (see src/m/classes/masscon_axpby.m): */
				iomodel->FetchMultipleData(&masscon_name_s,&num,MassconaxpbyNameEnum);
				iomodel->FetchMultipleData(&masscon_definitionenum_s,&num,MassconaxpbyDefinitionenumEnum);
				iomodel->FetchMultipleData(&masscon_namex_s,&num,MassconaxpbyNamexEnum);
				iomodel->FetchMultipleData(&masscon_namey_s,&num,MassconaxpbyNameyEnum);
				iomodel->FetchMultipleData(&masscon_alpha_s,&num,MassconaxpbyAlphaEnum);
				iomodel->FetchMultipleData(&masscon_beta_s,&num,MassconaxpbyBetaEnum);
				for(j=0;j<num;j++){

					/*Create a masscon axpyb object: */
					output_definitions->AddObject(new Massconaxpby(masscon_name_s[j],masscon_definitionenum_s[j],masscon_namex_s[j],masscon_namey_s[j],masscon_alpha_s[j],masscon_beta_s[j]));

				}

				/*Free ressources:*/
				for(j=0;j<num;j++){
					char* string=NULL;
					string = masscon_name_s[j];    xDelete<char>(string);
					string = masscon_namex_s[j];    xDelete<char>(string);
					string = masscon_namey_s[j];    xDelete<char>(string);
				}
				xDelete<char*>(masscon_name_s);
				xDelete<char*>(masscon_namex_s);
				xDelete<char*>(masscon_namey_s);
				xDelete<int>(masscon_definitionenum_s);
				xDelete<IssmDouble>(masscon_alpha_s);
				xDelete<IssmDouble>(masscon_beta_s);
				/*}}}*/
			}
			else _error_("output definition enum " << output_definition_enums[i] << "not supported yet!");
		}
	}
	parameters->AddObject(new DataSetParam(OutputdefinitionEnum,output_definitions));

	/*Free ressources:*/
	delete output_definitions;
	xDelete<int>(output_definition_enums);
}
