/*! \file SeaiceAnalysis.h 
 *  \brief: header file for generic external result object
 */

#ifndef _SeaiceAnalysis_
#define _SeaiceAnalysis_

/*Headers*/
#include "./Analysis.h"

class SeaiceAnalysis: public Analysis{

	public:
		/*Model processing*/
		void CreateConstraints(Constraints* constraints,IoModel* iomodel);
		void CreateLoads(Loads* loads, IoModel* iomodel);
		void CreateNodes(Nodes* nodes,IoModel* iomodel);
		int  DofsPerNode(int** doflist,int domaintype,int approximation);
		void UpdateElements(Elements* elements,IoModel* iomodel,int analysis_counter,int analysis_type);
		void UpdateParameters(Parameters* parameters,IoModel* iomodel,int solution_enum,int analysis_enum);

		/*Finite element Analysis*/
		void           Core(FemModel* femmodel);
		void           CreateCTensor(IssmDouble* C,Element* element,Gauss* gauss);
		ElementVector* CreateDVector(Element* element);
		ElementMatrix* CreateJacobianMatrix(Element* element);
		ElementMatrix* CreateKMatrix(Element* element);
		ElementVector* CreatePVector(Element* element);
		void           GetB(IssmDouble* B,Element* element,IssmDouble* xyz_list,Gauss* gauss);
		void           GetM(IssmDouble* M,Element* element,IssmDouble* xyz_list,Gauss* gauss);
		void           GetSolutionFromInputs(Vector<IssmDouble>* solution,Element* element);
		void           GradientJ(Vector<IssmDouble>* gradient,Element* element,int control_type,int control_index);
		void           InputUpdateFromSolution(IssmDouble* solution,Element* element);
		void           PostProcess(FemModel* femmodel);
		void           UpdateConstraints(FemModel* femmodel);
		void           UpdateDamageAndStress(FemModel* femmodel);
};
#endif
