/*! \file LsfReinitializationAnalysis.h 
 *  \brief: header file for generic external result object
 */

#ifndef _LsfReinitializationAnalysis_
#define _LsfReinitializationAnalysis_

/*Headers*/
#include "./Analysis.h"

class LsfReinitializationAnalysis: public Analysis{
	
public:
	/*Model processing*/
	void CreateConstraints(Constraints* constraints,IoModel* iomodel);
	void CreateLoads(Loads* loads, IoModel* iomodel);
	void CreateNodes(Nodes* nodes,IoModel* iomodel);
	int  DofsPerNode(int** doflist,int domaintype,int approximation);
	void UpdateElements(Elements* elements,IoModel* iomodel,int analysis_counter,int analysis_type);
	void UpdateParameters(Parameters* parameters,IoModel* iomodel,int solution_enum,int analysis_enum);

	/*Finite element Analysis*/
	void           Core(FemModel* femmodel);
	ElementVector* CreateDVector(Element* element);
	ElementMatrix* CreateJacobianMatrix(Element* element);
	ElementMatrix* CreateKMatrix(Element* element);
	ElementVector* CreatePVector(Element* element);
	void           GetB(IssmDouble* B,Element* element,IssmDouble* xyz_list,Gauss* gauss);
	void           GetBprime(IssmDouble* Bprime,Element* element,IssmDouble* xyz_list,Gauss* gauss);
	IssmDouble     GetDistanceToStraight(IssmDouble* q, IssmDouble* s0, IssmDouble* s1);
	void           GetSolutionFromInputs(Vector<IssmDouble>* solution,Element* element);
	void           GradientJ(Vector<IssmDouble>* gradient,Element* element,int control_type,int control_index);
	void           InputUpdateFromSolution(IssmDouble* solution,Element* element);
	bool           ReinitConvergence(Vector<IssmDouble>* lsfg,Vector<IssmDouble>* lsfg_old,IssmDouble reltol);
	void           SetDistanceOnIntersectedElements(FemModel* femmodel);
	void           SetDistanceToZeroLevelsetElement(Vector<IssmDouble>* vec_dist, Element* element);
	void           SetReinitSPCs(FemModel* femmodel);
	void           UpdateConstraints(FemModel* femmodel);
};
#endif
