%MASSFLUXATGATE class definition
%
%   Usage:
%      massfluxatgate=massfluxatgate();
%      massfluxatgate=massfluxatgate('name','GateName','definitionname',Outputdefinition1Enum,'profilename','PathToExpFile');

classdef massfluxatgate
	properties (SetAccess=public)  
		%massfluxatgate 
		name                = '';
		definitionenum     = NaN; %enum that identifies this output definition uniquely, from Outputdefinition[1-10]Enum
		profilename            = ''; 
	end
	properties (SetAccess=private)  
		segments            = NaN;
	end
	methods
		function obj = massfluxatgate(varargin) % {{{
			if nargin==0,
				obj=setdefaultparameters(obj);
			else
				%use provided options to change fields
				options=pairoptions(varargin{:});

				%get name
				obj.name=getfieldvalue(options,'name','');
				obj.definitionenum=getfieldvalue(options,'definitionenum');
				obj.profilename=getfieldvalue(options,'profilename');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{
		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{
			
			if ~ischar(obj.name),
				error('massfluxatgate error message: ''name'' field should be a string!');
			end
			if ~ischar(obj.profilename),
				error('massfluxatgate error message: ''profilename'' field should be a string!');
			end
			
			md = checkfield(md,'fieldname','obj.definitionenum','field',obj.definitionenum,'values',[Outputdefinition1Enum,Outputdefinition2Enum,Outputdefinition3Enum,Outputdefinition4Enum,Outputdefinition5Enum,Outputdefinition6Enum,Outputdefinition7Enum,Outputdefinition8Enum,Outputdefinition9Enum,Outputdefinition10Enum]);

			%check the profilename points to a file!: 
			if exist(obj.profilename,'file')~=2,
				error('massfluxatgate error message: file name for profile corresponding to gate does not point to a legitimate file on disk!');
			end
		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   Massfluxatgate:\n'));

			fielddisplay(obj,'name','identifier for this massfluxatgate response');
			fielddisplay(obj,'profilename','name of file (shapefile or argus file) defining a profile (or gate)');
			
		end % }}}
		function marshall(obj,md,fid) % {{{

		%before marshalling, we need to create the segments out of the profilename: 
		obj.segments=MeshProfileIntersection(md.mesh.elements,md.mesh.x,md.mesh.y,obj.profilename);

		%ok, marshall name and segments: 
		WriteData(fid,'object',obj,'fieldname','name','format','String');
		WriteData(fid,'object',obj,'fieldname','definitionenum','format','Integer');
		WriteData(fid,'object',obj,'fieldname','segments','format','DoubleMat','mattype',1);

		end % }}}
	end
end
