%MASSCONAXPBY class definition
%
%   Usage:
%      massconaxpby=massconaxpby();
%      massconsumaxpby=massconaxpby('name','MassCon58+35','namex','MassCon58','alpha',.5,'namey','MassCon35','beta',.5); 
% 
%   where name is the name of the massconaxpby object, namex is the name of the first masscon, namey the name of the second masscon and alpha,beta the 
%         multiplicators. The meaning of axpby here is: resulting masscon is the linear combination (alpha *x + beta * y) 
%         of two masscons.
%
%   See also: MASSCON

classdef massconaxpby
	properties (SetAccess=public)
		%masscon axpby
		name              = '';
		definitionenum   = NaN; %enum that identifies this output definition uniquely, from Outputdefinition[1-10]Enum
		namex              = '';
		namey              = '';
		alpha              = NaN;
		beta              = NaN;
	end
	
	methods
		function obj = massconaxpby(varargin) % {{{
			if nargin==0,
				obj=setdefaultparameters(obj);
			else
				%use provided options to change fields
				options=pairoptions(varargin{:});

				%get names
				obj.name=getfieldvalue(options,'name','');
				obj.definitionenum=getfieldvalue(options,'definitionenum');
				obj.namex=getfieldvalue(options,'namex');
				obj.namey=getfieldvalue(options,'namey');

				%get multiplicators: 
				obj.alpha=getfieldvalue(options,'alpha');
				obj.beta=getfieldvalue(options,'beta');


			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{
		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{

			if ~ischar(obj.name), error('masscon error message: ''name'' field should be a string!'); end
			if ~ischar(obj.namex), error('masscon error message: ''namex'' field should be a string!'); end
			if ~ischar(obj.namey), error('masscon error message: ''namey'' field should be a string!'); end
			
			md = checkfield(md,'fieldname','obj.definitionenum','field',obj.definitionenum,'values',[Outputdefinition1Enum,Outputdefinition2Enum,Outputdefinition3Enum,Outputdefinition4Enum,Outputdefinition5Enum,Outputdefinition6Enum,Outputdefinition7Enum,Outputdefinition8Enum,Outputdefinition9Enum,Outputdefinition10Enum]);

			md = checkfield(md,'fieldname','obj.alpha','field',obj.alpha,'NaN',1,'size',[1 1]);
			md = checkfield(md,'fieldname','obj.betaa','field',obj.beta,'NaN',1,'size',[1 1]);

		end % }}}
		function md = disp(obj) % {{{
		
			disp(sprintf('   Misfit:\n'));

			fielddisplay(obj,'name','name');
			fielddisplay(obj,'definitionenum','enum that identifies this output definition uniquely, from Outputdefinition[1-10]Enum');
			fielddisplay(obj,'namex','identifier for the first masscon');
			fielddisplay(obj,'alpha','first masscon multiplicator');
			fielddisplay(obj,'namey','identifier for the second masscon');
			fielddisplay(obj,'beta','second masscon multiplicator');

		end % }}}
		function md = marshall(obj,md,fid) % {{{

		WriteData(fid,'object',obj,'fieldname','name','format','String');
		WriteData(fid,'object',obj,'fieldname','definitionenum','format','Integer');
		WriteData(fid,'object',obj,'fieldname','namex','format','String');
		WriteData(fid,'object',obj,'fieldname','namey','format','String');
		WriteData(fid,'object',obj,'fieldname','alpha','format','Double');
		WriteData(fid,'object',obj,'fieldname','beta','format','Double');

		end % }}}
	end
end
