/*
 * FemModel.h: 
 */

#ifndef FEMMODEL_H_
#define FEMMODEL_H_

#include "../toolkits/toolkits.h"
#include "../DataSet/DataSet.h"
#include "../parallel/parallel.h"

class DataSet;
struct OptArgs;

class FemModel{

	/*no private members, as we need access to these datasets quite often!:*/

	public:

		DataSet*            elements;
		DataSet*            nodes;
		DataSet*            constraints;
		DataSet*            loads;
		DataSet*            materials;
		DataSet*            parameters;

		Vec                 partition;
		Vec                 tpartition;
		Vec                 yg;
		Mat                 Rmg;
		NodeSets*           nodesets;
		Vec                 ys;
		Vec                 ys0;
		Mat                 Gmn;

		FemModel();
		~FemModel();
		FemModel(DataSet* elements,DataSet* nodes,DataSet* constraints,DataSet* loads,DataSet* materials,DataSet* parameters,
			              Vec partition,Vec tpartition,Vec yg,Mat Rmg,Mat Gmn,NodeSets* nodesets,Vec ys,Vec ys0);
      
		void  Echo();
		void  DeepEcho();
		
		int FindParam(void* pparameter,char* parametername);
		DataSet* get_elements(void);
		DataSet* get_nodes(void);
		DataSet* get_constraints(void);
		DataSet* get_loads(void);
		DataSet* get_materials(void);
		DataSet* get_parameters(void);
		Vec      get_partition(void);
		Vec      get_tpartition(void);
		Vec      get_yg(void);
		Mat      get_Rmg(void);
		NodeSets* get_nodesets(void);
		Vec      get_ys(void);
		Vec      get_ys0(void);
		Mat      get_Gmn(void);



};


#endif
