function md=parameterize(md,parametername)
%PARAMETERIZE - parameterize a model
%
%   from a parameter matlab file, start filling in all the @model fields that were not 
%   filled in by the mesh.m and geography.m @model methods.
%   Warning: the paramter file must be able to be run in Matlab
%
%   Usage:
%      md=parameterize(md,parametername)
%
%   Example:
%      md=parameterize(md,'Square.par');

%some checks
if md.counter>=4,
	%We need to take this out, as it gets too constraining. 
	choice=input('This model already has parameters and has been extruded. Are you sure you want to go ahead? (y/n)','s');
	if ~strcmp(choice,'y')
		error('no parameters done ... exiting');
	end
elseif md.counter==3
	disp('This model already has parameters, overwriting...')
else
	if (md.counter<2)
		error('parameterize error message: you need to run geography.m first on this model');
	else
		md.counter=3;
	end
end
if ~exist(parametername),
	error(['parameterize error message: file ' parametername ' not found !']);
end

%Try and run parameter file.
copyfile(parametername,'TemporaryParameterFile.m');

try,
	TemporaryParameterFile
	delete('TemporaryParameterFile.m');
catch me,
	delete('TemporaryParameterFile.m');

	%copy error message
	me2=struct('message',me.message,'stack',me.stack);

	%rename parameter file
	for i=1:length(me2.stack)-1,
		if (length(me2.stack(i).file)>=24 & strcmp(me2.stack(i).file(end-23:end),'TemporaryParameterFile.m'))
			me2.stack(i).file=[me2.stack(i).file(1:end-24) parametername];
		end
		if strcmp(me2.stack(i).name,'TemporaryParameterFile'),
			me2.stack(i).name=parametername;
		end
		if strcmp(me2.stack(i).name,'parameterize'),
			%remove parameterize.m error "TemporaryParameterFile" misleading
			me2.stack(i)=[];
		end
	end

	%throw error message
	rethrow(me2);
end

%Keep track of parameter file
md.parameterfile=readfile(parametername);

%Name and notes
md.notes=['Model created by using parameter file: ' parametername ' on: ' datestr(now)];
[a,root,c,d]=fileparts(parametername); md.name=root;
