/*!\file: transient_core.cpp
 * \brief: core of the transient solution 
 */ 

#undef __FUNCT__ 
#define __FUNCT__ "transient_core"

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./parallel.h"
#include "../issm.h"

void transient_core(DataSet* results,Model* model, ParameterInputs* inputs){

	extern int my_rank;

	int dim=-1;

	//first recover parameters common to all solutions
	model->FindParam(&dim,"dim");

	//branch out 
	if(dim==2){
		transient_core_2d(results,model,inputs);
	}
	else if(dim==3){
		transient_core_3d(results,model,inputs);
	}
	else throw ErrorException(__FUNCT__,exprintf("%s%i%s"," dimension ",dim," not supported yet!"));

}
