
/*!\file: ControlTemporaryResults.cpp
 * \brief: core of the control solution 
 */ 

#undef __FUNCT__ 
#define __FUNCT__ "ControlTemporaryResults"

#include "./parallel.h"
#include "../issm.h"

void ControlTemporaryResults(Model* model,double* param_g,double* J,int n,ParameterInputs* inputs){

	extern int my_rank;

	/*fem models: */
	FemModel* fem_dh=NULL;

	/*output: */
	DataSet* temporary_results=NULL;
	Result*  result=NULL;
	char*    outputfilename=NULL;

	/*Intermediary: */
	int      i;
	DataSet* diagnostic_results=NULL;
	Vec      u_g=NULL;
	char*    control_type=NULL;
	int      gsize;
	int      numberofnodes;
	double* param_g_copy;
	double* J_copy;

	/*recover fem models: */
	fem_dh=model->GetFormulation(DiagnosticAnalysisEnum(),HorizAnalysisEnum());

	/*Recover parameters used throughout the solution:*/
	model->FindParam(&control_type,"control_type");
	model->FindParam(&numberofnodes,"numberofnodes");
	model->FindParam(&outputfilename,"outputfilename");
	gsize=fem_dh->nodes->NumberOfDofs();

	/*Launch diagnostic with the last parameter distribution*/
	inputs->Add(control_type,param_g,1,numberofnodes);
	diagnostic_results=new DataSet(ResultsEnum()); 
	diagnostic_core(diagnostic_results,model, inputs);

	//extract u_g from diagnostic_results, and erase diagnostic_results;
	diagnostic_results->FindResult(&u_g,"u_g");
	delete diagnostic_results;

	/*Plug COPYS of the results into output dataset: 
	 * only the pointer is given to temporary_results and at the
	 * end of ProcessResults the pointer is deleted. That would 
	 * destroy param_g and J*/

	J_copy=(double*)xcalloc(n+1,sizeof(double));
	for(i=0;i<n+1;i++) J_copy[i]=J[i];
	param_g_copy=(double*)xcalloc(numberofnodes,sizeof(double));
	for(i=0;i<numberofnodes;i++) param_g_copy[i]=param_g[i];

	temporary_results=new DataSet(ResultsEnum()); 
	result=new Result(temporary_results->Size()+1,0,1,"u_g",u_g);
	temporary_results->AddObject(result);
	result=new Result(temporary_results->Size()+1,0,1,"param_g",param_g_copy,gsize);
	temporary_results->AddObject(result);
	result=new Result(temporary_results->Size()+1,0,1,"J",J_copy,n+1);
	temporary_results->AddObject(result);

	//process results
	ProcessResults(&temporary_results,model,ControlAnalysisEnum());

	//Write results on disk
	OutputResults(temporary_results,outputfilename);
}
