/*
 * FemModel.h: 
 */

#ifndef FEMMODEL_H_
#define FEMMODEL_H_

#include "../toolkits/toolkits.h"
#include "../DataSet/DataSet.h"
#include "../parallel/parallel.h"

class DataSet;
struct OptArgs;

class FemModel{

	friend  Vec GradJCompute(ParameterInputs* inputs,FemModel* femmodel);
	friend	void diagnostic_core(DataSet* results,Model* model, ParameterInputs* inputs);
	friend	void prognostic_core(DataSet* results,Model* model, ParameterInputs* inputs);
	friend	void control_core(DataSet* results,Model* model, ParameterInputs* inputs);
	friend	void thermal_core(DataSet* results,Model* model, ParameterInputs* inputs);
	friend	void thermal_core_nonlinear(Vec* ptg,double* pmelting_offset,FemModel* fem,ParameterInputs* inputs,int analysis_type,int sub_analysis_type);
	friend	void steadystate_core(DataSet* results,Model* model, ParameterInputs* inputs);
	friend	void diagnostic_core_nonlinear(Vec* pug,Mat* pK_ff0,Mat* pK_fs0, DataSet* loads, FemModel* fem,ParameterInputs* inputs,int analysis_type,int sub_analysis_type);
	friend	void diagnostic_core_linear(Vec* ppg,FemModel* fem,ParameterInputs* inputs,int  analysis_type,int sub_analysis_type);
	friend	void transient_core(DataSet* results,Model* model, ParameterInputs* inputs);
	friend	void transient_core_2d(DataSet* results,Model* model, ParameterInputs* inputs);
	friend	void transient_core_3d(DataSet* results,Model* model, ParameterInputs* inputs);
	friend	double objectivefunctionC(double search_scalar,OptArgs* optargs);
	friend	int GradJSearch(double* search_vector,FemModel* femmodel,int step);
	friend	void OutputResults(DataSet* results,char* filename);
	friend	void WriteLockFile(char* filename);
	friend	void ControlInitialization(Model* model, ParameterInputs* inputs);
	friend	void ControlTemporaryResults(Model* model,double* param_g,double* J,int n,ParameterInputs* inputs);
	friend	void CreateFemModel(FemModel* femmodel,ConstDataHandle MODEL,int analysis_type,int sub_analysis_type);
	friend	void ProcessResults(DataSet** presults,Model* model,int analysis_type);
	friend  void SpawnCoreParallel(double* responses, int numresponses, double* variables, char** variables_descriptors,int numvariables, Model* model,ParameterInputs* inputs,int analysis_type,int sub_analysis_type,int counter);

	private: 
		DataSet*            elements;
		DataSet*            nodes;
		DataSet*            constraints;
		DataSet*            loads;
		DataSet*            materials;
		DataSet*            parameters;

		Vec                 partition;
		Vec                 tpartition;
		Vec                 yg;
		Mat                 Rmg;
		NodeSets*           nodesets;
		Vec                 ys;
		Vec                 ys0;
		Mat                 Gmn;

	public:

		FemModel();
		~FemModel();
		FemModel(DataSet* elements,DataSet* nodes,DataSet* constraints,DataSet* loads,DataSet* materials,DataSet* parameters,
			              Vec partition,Vec tpartition,Vec yg,Mat Rmg,Mat Gmn,NodeSets* nodesets,Vec ys,Vec ys0);
      
		void  Echo();
		void  DeepEcho();
		
		int FindParam(void* pparameter,char* parametername);
		DataSet* get_elements(void);
		DataSet* get_nodes(void);
		DataSet* get_constraints(void);
		DataSet* get_loads(void);
		DataSet* get_materials(void);
		DataSet* get_parameters(void);
		Vec      get_partition(void);
		Vec      get_tpartition(void);
		Vec      get_yg(void);
		Mat      get_Rmg(void);
		NodeSets* get_nodesets(void);
		Vec      get_ys(void);
		Vec      get_ys0(void);
		Mat      get_Gmn(void);



};


#endif
