/*\file io.h
 *\brief: I/O for ISSM
 */

#ifndef IO_H_
#define IO_H_

#include "../objects/NodeSets.h"
#include "../DataSet/DataSet.h"
#include "../include/types.h"

class DataSet;

void FetchData(void** pdata,int* pM,int* pN,ConstDataHandle data_handle,char* data_type,char* sub_data_type);
void WriteData(DataHandle* pdata_handle,void* data,int M,int N,char* data_type,char* sub_data_type);
void IoModelFetchData(void** pdata,int* pM,int* pN,ConstDataHandle model_handle,char* data_name,char* data_type,char* sub_data_type);

/*Serial: */
#ifdef _SERIAL_
void SerialFetchData(void** pdata,int* pM,int* pN,ConstDataHandle data_handle,char* data_type,char* sub_data_type);
void SerialWriteData(DataHandle* pdata_handle,void* data,int M,int N,char* data_type,char* sub_data_type);
void FetchNodeSets(NodeSets** pnodesets,ConstDataHandle dataref);
void WriteNodeSets(DataHandle* pdataref,NodeSets* nodesets);
void WriteParams(DataHandle* pdataref,DataSet* parameters);
#endif

/*Parallel: */
#ifdef _PARALLEL_
void ParallelFetchData(void** pdata,int* pM,int* pN,DataHandle data_handle, char* data_type,char* sub_data_type);
void ParallelFetchMat(double** pdata,int* pM,int* pN,DataHandle data_handle);
void ParallelFetchString(char** pdata,DataHandle data_handle);
void ParallelFetchScalar(double* pdata,DataHandle data_handle);
void ParallelFetchInteger(int* pdata,DataHandle data_handle);
void WriteDataToDisk(void* data,int* pM,int* pN,char* datatype,FILE* fid);
#endif

/*File I/O: */
FILE* pfopen(char* filename,char* format);
void  pfclose(FILE* fid,char* filename);

#endif	/* _IMDB_H */

