md=model;

md=triangle(md,'DomainOutline.exp',100000);
md=setmask(md,'all','');

md.materials=matdamageice();
md=parameterize(md,'Square.par');
md.initialization.vx = ones(md.mesh.numberofvertices,1);
md.initialization.vy = 0*ones(md.mesh.numberofvertices,1);
md.initialization.pressure = 0*ones(md.mesh.numberofvertices,1);
md.damage.isdamage=1;
md.damage.law=1;
md.damage.max_damage=0.8;
md.damage.D=0.5*ones(md.mesh.numberofvertices,1);
%md.damage.spcdamage=NaN*ones(md.mesh.numberofvertices,1);
md.damage.c1=1;
md.damage.c2=1;
md.damage.equiv_stress=0;
md.damage.stabilization=2;

%md=extrude(md,7,3);
md.surfaceforcings.mass_balance = zeros(md.mesh.numberofvertices,1);
md.basalforcings.groundedice_melting_rate = zeros(md.mesh.numberofvertices,1);
md.basalforcings.floatingice_melting_rate = zeros(md.mesh.numberofvertices,1);
md=setflowequation(md,'SSA','all');

md.timestepping.start_time = 0;
md.timestepping.final_time = 1.;
md.timestepping.time_step  = 0.1;

md.transient.isdamageevolution=1;
md.transient.isthermal=0;

md.cluster=generic('name',oshostname,'np',2);
md.stressbalance.requested_outputs={'default','DeviatoricStressxx','DeviatoricStressyy','DeviatoricStressxy'};
%md=solve(md,StressbalanceSolutionEnum());
md.verbose.solution = 1;
md=solve(md,TransientSolutionEnum());
