%FRICTIONWEERTMAN class definition
%
%   Usage:
%      frictionweertmantemp=frictionweertmantemp();

classdef frictionweertmantemp
	properties (SetAccess=public) 
		gamma = 0;
		C = NaN;
		m = NaN;
	end
	methods
		function obj = frictionweertmantemp(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{

			%Early return
			if ~ismember(StressbalanceAnalysisEnum(),analyses) & ~ismember(ThermalAnalysisEnum(),analyses), return; end
			md = checkfield(md,'fieldname','friction.C','forcing',1,'NaN',1);
			md = checkfield(md,'fieldname','friction.m','NaN',1,'size',[md.mesh.numberofelements 1]);
		end % }}}
		function disp(obj) % {{{
			disp('Weertman sliding law parameters:');
			disp('      Sigma_b = C^(-1/m) * |u_b|^(1/m-1)  u_b * 1/f(T)');
			disp(' ');
			fielddisplay(obj,'gamma','submelt sliding parameter f(T) = exp((T-Tpmp)/gamma)');
			fielddisplay(obj,'C','friction coefficient [SI]');
			fielddisplay(obj,'m','m exponent');
		end % }}}
		function marshall(obj,md,fid) % {{{
			yts=365.0*24.0*3600.0;

			WriteData(fid,'enum',FrictionLawEnum,'data',6,'format','Integer');
			WriteData(fid,'class','friction','object',obj,'fieldname','gamma','format','Double');
			WriteData(fid,'class','friction','object',obj,'fieldname','C','format','DoubleMat','mattype',1,'forcinglength',md.mesh.numberofvertices+1);
			WriteData(fid,'class','friction','object',obj,'fieldname','m','format','DoubleMat','mattype',2);
			

		end % }}}
	end
end
