%FRICTIONWEERTMAN class definition
%
%   Usage:
%      frictionweertman=frictionweertman();

classdef frictionweertman
	properties (SetAccess=public) 
		C = NaN;
		m = NaN;
	end
	methods
        function createxml(obj,fid) % {{{
            fprintf(fid, '\n\n');
            fprintf(fid, '%s\n', '<!-- Friction: Sigma= drag^2 * Neff ^r * u ^s, with Neff=rho_ice*g*thickness+rho_water*g*bed, r=q/p and s=1/p -->');
            fprintf(fid,'%s\n%s\n%s\n','<frame key="1" label="Friction: Sigma= drag^2 * Neff ^r * u ^s, with Neff=rho_ice*g*thickness+rho_water*g*bed, r=q/p and s=1/p">','<section name="frictionweertman" />');   
            fprintf(fid,'%s%s%s%s%s\n%s\n%s\n%s\n',    '<parameter key ="coefficient" type="',   	class(obj.coefficient),'" default="',     	convert2str(obj.coefficient),'">',              '     <section name="frictionweertman" />','     <help> frictionweertman coefficient [SI] </help>','</parameter>');
            fprintf(fid,'%s%s%s%s%s\n%s\n%s\n%s\n',    '<parameter key ="p" type="',               class(obj.p),'" default="',                 convert2str(obj.p),'">',   '     <section name="frictionweertman" />','     <help> p exponent </help>','</parameter>');
            fprintf(fid,'%s%s%s%s%s\n%s\n%s\n',        '<parameter key ="q" type="',               class(obj.q),'" default="',                 convert2str(obj.q),'">',            '     <section name="frictionweertman" />','     <help> q exponent </help>','</parameter>');
            fprintf(fid,'%s\n%s\n','</frame>');
        end % }}}
		function obj = frictionweertman(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{

			%Early return
			if ~ismember(StressbalanceAnalysisEnum(),analyses) & ~ismember(ThermalAnalysisEnum(),analyses), return; end
			md = checkfield(md,'fieldname','friction.C','forcing',1,'NaN',1);
			md = checkfield(md,'fieldname','friction.m','NaN',1,'size',[md.mesh.numberofelements 1]);
		end % }}}
		function disp(obj) % {{{
			disp(sprintf('Weertman sliding law parameters: Sigma_b = C^2 * |u_b|^(1/m-1) * u_b'));
			fielddisplay(obj,'C','friction coefficient [SI]');
			fielddisplay(obj,'m','m exponent');
		end % }}}
		function marshall(obj,md,fid) % {{{
			yts=365.0*24.0*3600.0;

			WriteData(fid,'enum',FrictionLawEnum,'data',2,'format','Integer');
			WriteData(fid,'class','friction','object',obj,'fieldname','C','format','DoubleMat','mattype',1,'forcinglength',md.mesh.numberofvertices+1);
			WriteData(fid,'class','friction','object',obj,'fieldname','m','format','DoubleMat','mattype',2);
			

		end % }}}
	end
end
