from fielddisplay import fielddisplay
from EnumDefinitions import *
from StringToEnum import StringToEnum
from checkfield import checkfield
from WriteData import WriteData

class calvinglevermann(object):
	"""
	CALVINGLEVERMANN class definition

	   Usage:
	      calvinglevermann=calvinglevermann();
	"""

	def __init__(self): # {{{
		self.coeff = float('NaN')

		#set defaults
		self.setdefaultparameters()

		#}}}
	def __repr__(self): # {{{
		string='   Calving Levermann parameters:'
		string="%s\n%s"%(string,fielddisplay(self,'coeff','proportionality coefficient in Levermann model'))

		return string
		#}}}
	def setdefaultparameters(self): # {{{

		#Proportionality coefficient in Levermann model
		self.coeff=2e13;
	#}}}
	def checkconsistency(self,md,solution,analyses):    # {{{

		#Early return
		if (solution!=TransientSolutionEnum()) or (not md.transient.iscalving):
			return md

		md = checkfield(md,'fieldname','calving.coeff','size',[md.mesh.numberofvertices],'>',0)
		return md
	# }}}
	def marshall(self,md,fid):    # {{{
		WriteData(fid,'enum',CalvingLawEnum(),'data',CalvingLevermannEnum(),'format','Integer');
		WriteData(fid,'enum',CalvinglevermannCoeffEnum(),'data',self.coeff,'format','DoubleMat','mattype',1)
	# }}}
