%FRICTIONWATERLAYER class definition
%
%   Usage:
%      frictionwaterlayer=frictionwaterlayer();

classdef frictiontemp
	properties (SetAccess=public) 
		coefficient = NaN;
		p           = NaN;
		q           = NaN;
		water_layer = NaN;
	end
	methods
		function obj = frictionwaterlayer(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					obj=structtoobj(frictiontemp(),varargin{1});
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{

			%Early return
			if ~ismember(StressbalanceAnalysisEnum(),analyses) & ~ismember(ThermalAnalysisEnum(),analyses), return; end

			md = checkfield(md,'fieldname','friction.coefficient','forcing',1,'NaN',1);
			md = checkfield(md,'fieldname','friction.q','NaN',1,'size',[md.mesh.numberofelements 1]);
			md = checkfield(md,'fieldname','friction.p','NaN',1,'size',[md.mesh.numberofelements 1]);
			md = checkfield(md,'fieldname','thermal.spctemperature','forcing',1,'>=',0.);

		end % }}}
		function disp(obj) % {{{
			disp(sprintf('Basal shear stress parameters: tau_b = coefficient^2 * Neff ^r * |u_b|^(s-1) * u_b * 1/f(T)\n(effective stress Neff=rho_ice*g*thickness+rho_water*g*(bed+water_layer), r=q/p and s=1/p)'));
			fielddisplay(obj,'coefficient','frictiontemp coefficient [SI]');
			fielddisplay(obj,'p','p exponent');
			fielddisplay(obj,'q','q exponent');
			fielddisplay(obj,'water_layer','water thickness at the base of the ice (m)');
		end % }}}
		function marshall(obj,md,fid) % {{{

			WriteData(fid,'enum',FrictionLawEnum,'data',5,'format','Integer');
			WriteData(fid,'class','friction','object',obj,'fieldname','coefficient','format','DoubleMat','mattype',1,'forcinglength',md.mesh.numberofvertices+1);
			WriteData(fid,'class','friction','object',obj,'fieldname','p','format','DoubleMat','mattype',2);
			WriteData(fid,'class','friction','object',obj,'fieldname','q','format','DoubleMat','mattype',2);
			WriteData(fid,'class','friction','object',obj,'fieldname','water_layer','format','DoubleMat','mattype',1,'forcinglength',md.mesh.numberofvertices+1);
		end % }}}
	end
end
