%CALVINGLEVERMANN class definition
%
%   Usage:
%      calvinglevermann=calvinglevermann();

classdef calvinglevermann
	properties (SetAccess=public) 
		 coeff = NaN;
	end
	methods
		function obj = calvinglevermann(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					inputstruct=varargin{1};
					list1 = properties('calvinglevermann');
					list2 = fieldnames(inputstruct);
					for i=1:length(list1)
						fieldname = list1{i};
						if ismember(fieldname,list2),
							obj.(fieldname) = inputstruct.(fieldname);
						end
					end
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{
			%Proportionality coefficient in Levermann model
			obj.coeff=2e13;
		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{
			%Early return
			if (solution~=TransientSolutionEnum() | md.transient.iscalving==0), return; end
			md = checkfield(md,'fieldname','calving.coeff','>',0,'size',[md.mesh.numberofvertices 1]);
		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   Calving Levermann parameters:'));
			fielddisplay(obj,'coeff','proportionality coefficient in Levermann model');

		end % }}}
		function marshall(obj,md,fid) % {{{
			WriteData(fid,'enum',CalvingLawEnum(),'data',CalvingLevermannEnum(),'format','Integer');
			WriteData(fid,'enum',CalvinglevermannCoeffEnum(),'data',obj.coeff,'format','DoubleMat','mattype',1);
		end % }}}
	end
end
