from fielddisplay import fielddisplay
from EnumDefinitions import *
from StringToEnum import StringToEnum
from checkfield import checkfield
from WriteData import WriteData

class calving(object):
	"""
	CALVING class definition

	   Usage:
	      calving=calving();
	"""

	def __init__(self): # {{{
		self.calvingrate            = float('NaN')

		#set defaults
		self.setdefaultparameters()

		#}}}
	def __repr__(self): # {{{
		string='   Calving parameters:'
		string="%s\n%s"%(string,fielddisplay(self,'calvingrate','calving rate at given location [m/a]'))

		return string
		#}}}
	def setdefaultparameters(self): # {{{

		return self
	#}}}
	def checkconsistency(self,md,solution,analyses):    # {{{

		#Early return
		if (solution!=TransientSolutionEnum()) or (not md.transient.iscalving):
			return md

		md = checkfield(md,'fieldname','calving.calvingrate','NaN',1,'size',[md.mesh.numberofvertices],'>=',0)
		return md
	# }}}
	def marshall(self,md,fid):    # {{{

		yts=365.*24.*3600.

		WriteData(fid,'enum',CalvingLawEnum(),'data',DefaultCalvingEnum(),'format','Integer');
		WriteData(fid,'object',self,'fieldname','calvingrate','format','DoubleMat','mattype',1,'forcinglength',md.mesh.numberofvertices+1,'scale',1./yts)
	# }}}
