%CALVING class definition
%
%   Usage:
%      calving=calving();

classdef calving
	properties (SetAccess=public) 
		 calvingrate            = NaN;
	end
	methods (Static)
		function obj = loadobj(obj) % {{{
			% This function is directly called by matlab when a model object is
			% loaded. If the input is a struct it is an old version of this class and
			% old fields must be recovered (make sure they are in the deprecated
			% model properties)

			if verLessThan('matlab','7.9'),
				disp('Warning: your matlab version is old and there is a risk that load does not work correctly');
				disp('         if the model is not loaded correctly, rename temporarily loadobj so that matlab does not use it');

				% This is a Matlab bug: all the fields of md have their default value
				% Example of error message:
				% Warning: Error loading an object of class 'model':
				% Undefined function or method 'exist' for input arguments of type 'cell'
				%
				% This has been fixed in MATLAB 7.9 (R2009b) and later versions
			end

			if isstruct(obj)
				disp('Recovering calving from older version');
				objstruct = obj;
				obj = structtoobj(calving(),objstruct);
			end
		end% }}}
	end
	methods
		function obj = calving(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					inputstruct=varargin{1};
					list1 = properties('calving');
					list2 = fieldnames(inputstruct);
					for i=1:length(list1)
						fieldname = list1{i};
						if ismember(fieldname,list2),
							obj.(fieldname) = inputstruct.(fieldname);
						end
					end
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{
			%Early return
			if (solution~=TransientSolutionEnum() | md.transient.iscalving==0), return; end
			md = checkfield(md,'fieldname','calving.calvingrate','NaN',1,'size',[md.mesh.numberofvertices 1],'>=',0);
		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   Calving parameters:'));
			fielddisplay(obj,'calvingrate','calving rate at given location [m/a]');
		end % }}}
		function marshall(obj,md,fid) % {{{
			yts=365.0*24.0*3600.0;
			WriteData(fid,'enum',CalvingLawEnum(),'data',DefaultCalvingEnum(),'format','Integer');
			WriteData(fid,'object',obj,'fieldname','calvingrate','format','DoubleMat','mattype',1,'forcinglength',md.mesh.numberofvertices+1,'scale',1./yts);
		end % }}}
	end
end
