function hostname=oshostname()
%OSHOSTNAME figure out hostname, irrespective of os type
%
%   usage: hostname=oshostname();
%
%
hostname='sylvestre';
return;

if ispc(),
	[status,hostname]=system('hostname');
	if status, 
		error('oshostname error message: could not run hostname command on windows os');
	end
else
	%See http://www.mathworks.com/help/matlab/ref/system.html "tips" section
	%We need to add < /dev/null otherwise what is in the clipboard is added
	[status,hostname]=system('hostname < /dev/null');
	hostname = strrep(hostname,'-','');
	if status, 
		error('oshostname error message: could not run hostname command on *nix os');
	end
end

%remove carriage return and blank spaces
hostname=hostname(1:end-1);
hostname=ddewhite(hostname);
