/*
 * \file EnumDefinitions.h:
 * \brief: enum functions for our objects
 */

#ifndef _ENUM_DEFINITIONS_
#define _ENUM_DEFINITIONS_

enum definitions{
	/*Model fields {{{*/
	AutodiffIsautodiffEnum, 
	AutodiffNumDependentsEnum,
	AutodiffNumDependentObjectsEnum,
	AutodiffDependentObjectNamesEnum,
	AutodiffDependentObjectTypesEnum,
	AutodiffDependentObjectIndicesEnum,
	AutodiffDependentObjectsEnum,
	AutodiffNumIndependentsEnum,
	AutodiffNumIndependentObjectsEnum,
	AutodiffIndependentObjectNamesEnum,
	AutodiffIndependentObjectTypesEnum,
	AutodiffIndependentObjectsEnum,
	AutodiffJacobianEnum,
	AutodiffXpEnum,
	AutodiffDriverEnum,
	AutodiffFosForwardIndexEnum,
	AutodiffFovForwardIndicesEnum,
	AutodiffFosReverseIndexEnum,
	AutodiffMassFluxSegmentsPresentEnum,
	AutodiffKeepEnum,
	AutodiffObufsizeEnum,
	AutodiffLbufsizeEnum,
	AutodiffCbufsizeEnum,
	AutodiffTbufsizeEnum,
	AutodiffGcTriggerRatioEnum,
	AutodiffGcTriggerMaxSizeEnum,
	BalancethicknessSpcthicknessEnum,
	BalancethicknessStabilizationEnum,
	BalancethicknessThickeningRateEnum,
	BasalforcingsEnum,
	BasalforcingsGeothermalfluxEnum,
	BasalforcingsGroundediceMeltingRateEnum,
	BasalforcingsFloatingiceMeltingRateEnum,
	BasalforcingsDeepwaterMeltingRateEnum,
	BasalforcingsDeepwaterElevationEnum,
	BasalforcingsUpperwaterElevationEnum,
	FloatingMeltRateEnum,
	LinearFloatingMeltRateEnum,
	BedEnum,
	BaseEnum,
	ConstantsGEnum,
	ConstantsOmegaEnum,
	ConstantsReferencetemperatureEnum,
	ConstantsYtsEnum,
	DependentObjectEnum,
	StressbalanceAbstolEnum,
	StressbalanceIsnewtonEnum,
	StressbalanceMaxiterEnum,
	StressbalancePenaltyFactorEnum,
	StressbalanceReferentialEnum,
	StressbalanceReltolEnum,
	StressbalanceNumRequestedOutputsEnum,
	StressbalanceRequestedOutputsEnum,
	StressbalanceRestolEnum,
	StressbalanceRiftPenaltyLockEnum,
	StressbalanceRiftPenaltyThresholdEnum,
	StressbalanceShelfDampeningEnum,
	StressbalanceSpcvxEnum,
	StressbalanceSpcvyEnum,
	StressbalanceSpcvzEnum,
	StressbalanceFSreconditioningEnum,
	StressbalanceVertexPairingEnum,
	StressbalanceViscosityOvershootEnum,
	LoadingforceXEnum,
	LoadingforceYEnum,
	LoadingforceZEnum,
	FlowequationBorderSSAEnum,
	FlowequationBorderHOEnum,
	FlowequationBorderFSEnum,
	FlowequationElementEquationEnum,
	FlowequationIsSIAEnum,
	FlowequationIsSSAEnum,
	FlowequationIsL1L2Enum,
	FlowequationIsHOEnum,
	FlowequationIsFSEnum,
	FlowequationFeSSAEnum,
	FlowequationFeHOEnum,
	FlowequationFeFSEnum,
	FlowequationVertexEquationEnum,
	FrictionAsEnum,
	FrictionCoefficientEnum,
	FrictionPEnum,
	FrictionQEnum,
	FrictionMEnum,
	FrictionCEnum,
	FrictionLawEnum,
	FrictionGammaEnum,
	GeometryHydrostaticRatioEnum,
	HydrologyModelEnum,
	HydrologyshreveEnum,
	HydrologyshreveSpcwatercolumnEnum,
	HydrologyshreveStabilizationEnum,
	HydrologydcEnum,
	SedimentHeadEnum,
	SedimentHeadOldEnum,
	SedimentHeadResidualEnum,
	EffectivePressureEnum,
	EplHeadEnum,
	EplHeadOldEnum,
	EplHeadSlopeXEnum,
	EplHeadSlopeYEnum,
	EplZigZagCounterEnum,
	HydrologydcMaxIterEnum,
	HydrologydcRelTolEnum,
	HydrologydcSpcsedimentHeadEnum,
	HydrologydcSedimentCompressibilityEnum,
	HydrologydcSedimentPorosityEnum,
	HydrologydcSedimentThicknessEnum,
	HydrologydcSedimentTransmitivityEnum,
	HydrologydcWaterCompressibilityEnum,
	HydrologydcSpceplHeadEnum,
	HydrologydcMaskEplactiveNodeEnum,
	HydrologydcMaskEplactiveEltEnum,
	HydrologydcEplCompressibilityEnum,
	HydrologydcEplPorosityEnum,
	HydrologydcEplInitialThicknessEnum,
	HydrologydcEplColapseThicknessEnum,
	HydrologydcEplMaxThicknessEnum,
	HydrologydcEplThicknessEnum,
	HydrologydcEplThicknessOldEnum,
	HydrologydcEplConductivityEnum,
	HydrologydcIsefficientlayerEnum,
	HydrologydcSedimentlimitFlagEnum,
	HydrologydcSedimentlimitEnum,
	HydrologydcTransferFlagEnum,
	HydrologydcLeakageFactorEnum,
	HydrologydcPenaltyFactorEnum,
	HydrologydcPenaltyLockEnum,
	HydrologydcBasalMoulinInputEnum,
	HydrologyLayerEnum,
	HydrologySedimentEnum,
	HydrologyEfficientEnum,
	HydrologySedimentKmaxEnum,
	IndependentObjectEnum,
	InversionControlParametersEnum,
	InversionControlScalingFactorsEnum,
	InversionCostFunctionThresholdEnum,
	InversionCostFunctionsCoefficientsEnum,
	InversionCostFunctionsEnum,
	InversionGradientScalingEnum,
	InversionIscontrolEnum,
	InversionTypeEnum,
	InversionIncompleteAdjointEnum,
	InversionMaxParametersEnum,
	InversionMaxiterPerStepEnum,
	InversionMaxiterEnum,
	InversionMaxstepsEnum,
	InversionFatolEnum,
	InversionFrtolEnum,
	InversionGatolEnum,
	InversionGrtolEnum,
	InversionGttolEnum,
	InversionAlgorithmEnum,
	InversionMinParametersEnum,
	InversionNstepsEnum,
	InversionDxminEnum,
	InversionNumControlParametersEnum,
	InversionNumCostFunctionsEnum,
	InversionStepThresholdEnum,
	InversionThicknessObsEnum,
	InversionSurfaceObsEnum,
	InversionVxObsEnum,
	InversionVyObsEnum,
	InversionVzObsEnum,
	MaskIceLevelsetEnum,
	MaterialsBetaEnum,
	MaterialsHeatcapacityEnum,
	MaterialsLatentheatEnum,
	MaterialsMeltingpointEnum,
	MaterialsMixedLayerCapacityEnum,
	MaterialsRheologyBEnum,
	MaterialsRheologyBbarEnum,
	MaterialsRheologyLawEnum,
	MaterialsRheologyNEnum,
	DamageIsdamageEnum,
	DamageDEnum,
	DamageFEnum,
	DamageDbarEnum,
	DamageLawEnum,
	DamageC1Enum,
	DamageC2Enum,
	DamageC3Enum,
	DamageC4Enum,
	DamageElementinterpEnum,
	DamageHealingEnum,
	DamageStressThresholdEnum,
	DamageStabilizationEnum,
	DamagePenaltyThresholdEnum,
	DamagePenaltyLockEnum,
	DamagePenaltyFactorEnum,
	DamageMaxiterEnum,
	DamageSpcdamageEnum,
	DamageMaxDamageEnum,
	DamageEquivStressEnum,
	DamageEvolutionNumRequestedOutputsEnum,
	DamageEvolutionRequestedOutputsEnum,
	DamageEnum,
	NewDamageEnum,
	StressIntensityFactorEnum,
	StrainRateparallelEnum,
	StrainRateperpendicularEnum,
	MaterialsRhoIceEnum,
	MaterialsRhoSeawaterEnum,
	MaterialsRhoFreshwaterEnum,
	MaterialsMuWaterEnum,
	MaterialsThermalExchangeVelocityEnum,
	MaterialsThermalconductivityEnum,
	MaterialsTemperateiceconductivityEnum,
	MaterialsLithosphereShearModulusEnum,
	MaterialsLithosphereDensityEnum,
	MaterialsMantleShearModulusEnum,
	MaterialsMantleDensityEnum,
	MeshAverageVertexConnectivityEnum,
	MeshElements2dEnum,
	MeshElementsEnum,
	MeshLowerelementsEnum,
	MeshNumberofelements2dEnum,
	MeshNumberofelementsEnum,
	MeshNumberoflayersEnum,
	MeshNumberofvertices2dEnum,
	MeshNumberofverticesEnum,
	MeshUpperelementsEnum,
	MeshVertexonbaseEnum,
	MeshVertexonsurfaceEnum,
	MeshVertexonboundaryEnum,
	MeshXEnum,
	MeshYEnum,
	MeshZEnum,
	MeshElementtypeEnum,
	DomainTypeEnum,
	DomainDimensionEnum,
	Domain2DhorizontalEnum,
	Domain2DverticalEnum,
	Domain3DEnum,
	MiscellaneousNameEnum, //FIXME: only used by qmu, should not be marshalled (already in queueing script)
	MasstransportHydrostaticAdjustmentEnum,
	MasstransportIsfreesurfaceEnum,
	MasstransportMinThicknessEnum,
	MasstransportPenaltyFactorEnum,
	MasstransportSpcthicknessEnum,
	MasstransportCalvingrateEnum,
	MasstransportStabilizationEnum,
	MasstransportVertexPairingEnum,
	MasstransportNumRequestedOutputsEnum,
	MasstransportRequestedOutputsEnum,
	QmuIsdakotaEnum,
	MassFluxSegmentsEnum,
	MassFluxSegmentsPresentEnum,
	QmuMassFluxSegmentsPresentEnum,
	QmuNumberofpartitionsEnum,
	QmuNumberofresponsesEnum,
	QmuPartitionEnum,
	QmuResponsedescriptorsEnum,
	QmuVariabledescriptorsEnum,
	RiftsNumriftsEnum,
	RiftsRiftstructEnum,
	SettingsResultsOnNodesEnum,
	SettingsIoGatherEnum,
	SettingsLowmemEnum,
	SettingsOutputFrequencyEnum,
	SettingsWaitonlockEnum,
	DebugProfilingEnum,
	ProfilingCurrentMemEnum,
	ProfilingCurrentFlopsEnum,
	ProfilingSolutionTimeEnum,
	MaxIterationConvergenceFlagEnum,
	SteadystateMaxiterEnum,
	SteadystateNumRequestedOutputsEnum,
	SteadystateReltolEnum,
	SteadystateRequestedOutputsEnum,
	SurfaceEnum,
	ThermalIsenthalpyEnum,
	ThermalIsdynamicbasalspcEnum,
	ThermalReltolEnum,
	ThermalMaxiterEnum,
	ThermalPenaltyFactorEnum,
	ThermalPenaltyLockEnum,
	ThermalPenaltyThresholdEnum,
	ThermalSpctemperatureEnum,
	ThermalStabilizationEnum,
	ThermalNumRequestedOutputsEnum,
	ThermalRequestedOutputsEnum,
	GiaMantleViscosityEnum,
	GiaLithosphereThicknessEnum,
	ThicknessEnum,
	TimesteppingStartTimeEnum,
	TimesteppingFinalTimeEnum,
	TimesteppingCflCoefficientEnum,
	TimesteppingTimeAdaptEnum,
	TimesteppingTimeStepEnum,
	TimesteppingInterpForcingsEnum,
	TransientIsstressbalanceEnum,
	TransientIsgroundinglineEnum,
	TransientIsmasstransportEnum,
	TransientIsthermalEnum,
	TransientIsgiaEnum,
	TransientIsdamageevolutionEnum,
	TransientIshydrologyEnum,
	TransientNumRequestedOutputsEnum,
	TransientRequestedOutputsEnum,
	PotentialEnum,
	BalancethicknessSpcpotentialEnum,
	BalancethicknessApparentMassbalanceEnum,
	Balancethickness2MisfitEnum,
	BalancethicknessDiffusionCoefficientEnum,
	BalancethicknessCmuEnum,
	BalancethicknessOmegaEnum,
	BalancethicknessD0Enum,
	/*}}}*/
	/*Surfaceforcings{{{*/
	SurfaceforcingsEnum,
	SMBEnum,
	SurfaceforcingsMassBalanceEnum,
	SMBpddEnum,
	SurfaceforcingsDelta18oEnum,
	SurfaceforcingsDelta18oSurfaceEnum,
	SurfaceforcingsIsdelta18oEnum,
	SurfaceforcingsPrecipitationsPresentdayEnum,
	SurfaceforcingsTemperaturesPresentdayEnum,
	SurfaceforcingsTemperaturesLgmEnum,
	SurfaceforcingsPrecipitationEnum,
	SurfaceforcingsDesfacEnum,
	SurfaceforcingsS0pEnum,
	SurfaceforcingsS0tEnum,
	SurfaceforcingsRlapsEnum,
	SurfaceforcingsRlapslgmEnum,
	SurfaceforcingsPfacEnum,
	SurfaceforcingsTdiffEnum,
	SurfaceforcingsSealevEnum,
	SMBgradientsEnum,
	SurfaceforcingsMonthlytemperaturesEnum,
	SurfaceforcingsHrefEnum,
	SurfaceforcingsSmbrefEnum,
	SurfaceforcingsBPosEnum,
	SurfaceforcingsBNegEnum,
	SMBhenningEnum,
	SMBcomponentsEnum,
	SurfaceforcingsAccumulationEnum,
	SurfaceforcingsEvaporationEnum,
	SurfaceforcingsRunoffEnum,
	SMBmeltcomponentsEnum,
	SurfaceforcingsMeltEnum,
	SurfaceforcingsRefreezeEnum,
	/*TO BE REMOVED*/
	SurfaceforcingsIspddEnum,
	SurfaceforcingsIssmbgradientsEnum,
	/*}}}*/
	/*Solutions and Analyses{{{ */
	SolutionTypeEnum,
	AnalysisTypeEnum,
	ConfigurationTypeEnum,
	AdjointBalancethicknessAnalysisEnum,
	AdjointBalancethickness2AnalysisEnum,
	AdjointHorizAnalysisEnum,
	AnalysisCounterEnum,
	DefaultAnalysisEnum,
	BalancethicknessAnalysisEnum,
	BalancethicknessSolutionEnum,
	Balancethickness2AnalysisEnum,
	Balancethickness2SolutionEnum,
	BalancethicknessSoftAnalysisEnum,
	BalancethicknessSoftSolutionEnum,
	BalancevelocityAnalysisEnum,
	BalancevelocitySolutionEnum,
	L2ProjectionEPLAnalysisEnum,
	L2ProjectionBaseAnalysisEnum,
	BedSlopeSolutionEnum,
	DamageEvolutionSolutionEnum,
	DamageEvolutionAnalysisEnum,
	StressbalanceAnalysisEnum,
	StressbalanceSIAAnalysisEnum,
	StressbalanceSolutionEnum,
	StressbalanceVerticalAnalysisEnum,
	EnthalpyAnalysisEnum,
	FlaimAnalysisEnum,
	FlaimSolutionEnum,
	HydrologyShreveAnalysisEnum,
	HydrologyDCInefficientAnalysisEnum,
	HydrologyDCEfficientAnalysisEnum,
	HydrologySolutionEnum,
	MeltingAnalysisEnum,
	MasstransportAnalysisEnum,
	MasstransportSolutionEnum,
	FreeSurfaceBaseAnalysisEnum,
	FreeSurfaceTopAnalysisEnum,
	SurfaceNormalVelocityEnum,
	ExtrudeFromBaseAnalysisEnum,
	ExtrudeFromTopAnalysisEnum,
	DepthAverageAnalysisEnum,
	SteadystateSolutionEnum,
	SurfaceSlopeSolutionEnum,
	SmoothAnalysisEnum,
	ThermalAnalysisEnum,
	ThermalSolutionEnum,
	TransientSolutionEnum,
	UzawaPressureAnalysisEnum,
	GiaSolutionEnum,
	GiaAnalysisEnum,
	SeaiceSolutionEnum,
	SeaiceAnalysisEnum,
	MeshdeformationSolutionEnum,
	MeshdeformationAnalysisEnum,
	LevelsetAnalysisEnum,
	LevelsetStabilizationEnum,
	ExtrapolationAnalysisEnum,
	LsfReinitializationAnalysisEnum,
	/*}}}*/
	/*Approximations {{{*/
	ApproximationEnum,
	NoneApproximationEnum,
	SIAApproximationEnum,
	SSAApproximationEnum,
	SSAHOApproximationEnum,
	SSAFSApproximationEnum,
	L1L2ApproximationEnum,
	HOApproximationEnum,
	HOFSApproximationEnum,
	FSApproximationEnum,
	FSvelocityEnum,
	FSpressureEnum,
	/*}}}*/
	/*Datasets {{{*/
	ConstraintsEnum,
	LoadsEnum,
	MaterialsEnum,
	NodesEnum,
	ContoursEnum,
	ParametersEnum,
	VerticesEnum,
	ResultsEnum,
	/*}}}*/
	/*Objects {{{*/
	GenericParamEnum,
	AdolcParamEnum,
	BoolInputEnum,
	BoolParamEnum,
	ContourEnum,
	ControlInputEnum,
	DatasetInputEnum,
	DoubleInputEnum,
	DataSetParamEnum,
	DoubleMatArrayParamEnum,
	DoubleMatParamEnum,
	DoubleParamEnum,
	DoubleVecParamEnum,
	ElementEnum,
	ExternalResultEnum,
	FileParamEnum,
	InputEnum,
	IntInputEnum,
	InputToExtrudeEnum,
	InputToL2ProjectEnum,
	InputToDepthaverageEnum,
	InputToSmoothEnum,
	SmoothThicknessMultiplierEnum,
	IntParamEnum,
	IntVecParamEnum,
	TransientParamEnum,
	MaticeEnum,
	MatdamageiceEnum,
	MatparEnum,
	NodeEnum,
	NumericalfluxEnum,
	NumericalfluxTypeEnum,
	ParamEnum,
	PengridEnum,
	PenpairEnum,
	ProfilerEnum,
	MatrixParamEnum,
	NodeSIdEnum,
	VectorParamEnum,
	RiftfrontEnum,
	RiftfrontTypeEnum,
	SegmentEnum,
	SegmentRiftfrontEnum,
	SpcDynamicEnum,
	SpcStaticEnum,
	SpcTransientEnum,
	StringArrayParamEnum,
	StringParamEnum,
	SegEnum,
	SegInputEnum,
	TriaEnum,
	TriaInputEnum,
	TetraEnum,
	TetraInputEnum,
	PentaEnum,
	PentaInputEnum,
	VertexEnum,
	VertexPIdEnum,
	VertexSIdEnum,
	/*}}}*/
	/*Fill {{{*/
	AirEnum,
	IceEnum,
	MelangeEnum,
	WaterEnum,
	/*}}}*/
	/*Rift state {{{*/
	ClosedEnum,
	FreeEnum,
	OpenEnum,
	/*}}}*/
	/*Inputs {{{*/
	AdjointpEnum,
	AdjointxEnum,
	AdjointyEnum,
	AdjointzEnum,
	BalancethicknessMisfitEnum,
	BedSlopeXEnum,
	BedSlopeYEnum,
	BoundaryEnum,
	ConvergedEnum,
	FillEnum,
	FractionIncrementEnum,
	FrictionEnum,
	InternalEnum,
	MassFluxEnum,
	MeltingOffsetEnum,
	MisfitEnum,
	PressureEnum,
	PressurePicardEnum,
	AndroidFrictionCoefficientEnum,
	ResetPenaltiesEnum,
	SegmentOnIceShelfEnum,
	SurfaceAbsVelMisfitEnum,
	SurfaceAreaEnum,
	SurfaceAverageVelMisfitEnum,
	SurfaceLogVelMisfitEnum,
	SurfaceLogVxVyMisfitEnum,
	SurfaceRelVelMisfitEnum,
	SurfaceSlopeXEnum,
	SurfaceSlopeYEnum,
	TemperatureEnum,
	TemperaturePicardEnum,
	ThicknessAbsMisfitEnum,
	SurfaceAbsMisfitEnum,
	VelEnum,
	VelocityEnum,
	VxAverageEnum,
	VxEnum,
	VxPicardEnum,
	VyAverageEnum,
	VyEnum,
	VyPicardEnum,
	VzEnum,
	VzSSAEnum,
	VzHOEnum,
	VzPicardEnum,
	VzFSEnum,
	VxMeshEnum,
	VyMeshEnum,
	VzMeshEnum,
	EnthalpyEnum,
	EnthalpyPicardEnum,
	ThicknessAbsGradientEnum,
	ThicknessAlongGradientEnum,
	ThicknessAcrossGradientEnum,
	IntMatParamEnum,
	RheologyBbarAbsGradientEnum,
	DragCoefficientAbsGradientEnum,
	TransientInputEnum,
	WaterfractionEnum,
	WatercolumnEnum,
	BasalFrictionEnum,
	ViscousHeatingEnum,
	HydrologyWaterVxEnum,
	HydrologyWaterVyEnum,
	DrivingStressXEnum,
	DrivingStressYEnum,
	SigmaNNEnum,
	StressTensorEnum,
	StressTensorxxEnum,
	StressTensorxyEnum,
	StressTensorxzEnum,
	StressTensoryyEnum,
	StressTensoryzEnum,
	StressTensorzzEnum,
	StressMaxPrincipalEnum,
	DeviatoricStressEnum,
	DeviatoricStressxxEnum,
	DeviatoricStressxyEnum,
	DeviatoricStressxzEnum,
	DeviatoricStressyyEnum,
	DeviatoricStressyzEnum,
	DeviatoricStresszzEnum,
	StrainRateEnum,
	StrainRatexxEnum,
	StrainRatexyEnum,
	StrainRatexzEnum,
	StrainRateyyEnum,
	StrainRateyzEnum,
	StrainRatezzEnum,
	DivergenceEnum,
	MaxDivergenceEnum,
	GiaCrossSectionShapeEnum,
	GiadWdtEnum,
	GiaWEnum,
	/*}}}*/
	/*Element Interpolations{{{*/
	P0Enum,
	P1Enum,
	P1DGEnum,
	P1bubbleEnum,
	P1bubblecondensedEnum,
	P2Enum,
	P2bubbleEnum,
	P2bubblecondensedEnum,
	P2xP1Enum,
	P1xP2Enum,
	P1xP3Enum,
	P2xP4Enum,
	P1P1Enum,
	P1P1GLSEnum,
	MINIEnum,
	MINIcondensedEnum,
	TaylorHoodEnum,
	LATaylorHoodEnum,
	XTaylorHoodEnum,
	OneLayerP4zEnum,
	CrouzeixRaviartEnum,
	LACrouzeixRaviartEnum,
	/*}}}*/
	/*Results{{{*/
	SaveResultsEnum,
	BoolExternalResultEnum,
	DoubleExternalResultEnum,
	DoubleMatExternalResultEnum,
	IntExternalResultEnum,
	JEnum,
	StringExternalResultEnum,
	StepEnum,
	TimeEnum,
	WaterColumnOldEnum,
	/*}}}*/
	/*Output Definitions{{{*/
	OutputdefinitionEnum,
	OutputdefinitionListEnum,
	MassfluxatgateEnum,
	MassfluxatgateNameEnum,
	MassfluxatgateSegmentsEnum,
	MisfitNameEnum,
	MisfitModelEnumEnum,
	MisfitObservationEnum,
	MisfitObservationEnumEnum,
	MisfitTimeinterpolationEnum,
	MisfitWeightsEnum,
	MisfitWeightsEnumEnum,
	SurfaceObservationEnum,
	WeightsSurfaceObservationEnum,
	/*}}}*/
	/*Responses{{{*/
	MinVelEnum,
	MaxVelEnum,
	MinVxEnum,
	MaxVxEnum,
	MaxAbsVxEnum,
	MinVyEnum,
	MaxVyEnum,
	MaxAbsVyEnum,
	MinVzEnum,
	MaxVzEnum,
	MaxAbsVzEnum,
	IceVolumeEnum,
	IceVolumeAboveFloatationEnum,
	TotalSmbEnum,
	/*}}}*/
	/*Relaxation{{{*/
	AbsoluteEnum,
	IncrementalEnum,
	AugmentedLagrangianREnum,
	AugmentedLagrangianRhopEnum,
	AugmentedLagrangianRlambdaEnum,
	AugmentedLagrangianRholambdaEnum,
	AugmentedLagrangianThetaEnum,
	/*}}}*/
	/*Grounding Line{{{*/
	NoneEnum,
	AggressiveMigrationEnum,
	SoftMigrationEnum,
	SubelementMigrationEnum,
	SubelementMigration2Enum,
	ContactEnum,
	MaskGroundediceLevelsetEnum,
	/*}}}*/
	/*Gauss{{{*/
	GaussSegEnum,
	GaussTriaEnum,
	GaussTetraEnum,
	GaussPentaEnum,
	/*}}}*/
	/*Solver{{{*/
	FSSolverEnum,
	/*}}}*/
	/*Parameters{{{*/
	AdjointEnum,
	ColinearEnum,
	ControlSteadyEnum,
	FsetEnum,
	Gradient1Enum,
	Gradient2Enum,
	Gradient3Enum,
	GradientEnum,
	GroundinglineMigrationEnum,
	GsetEnum,
	IndexEnum,
	IndexedEnum,
	IntersectEnum,
	NodalEnum,
	OldGradientEnum,
	OutputFilePointerEnum,
	OutputFileNameEnum,
	LockFileNameEnum,
	ToolkitsOptionsAnalysesEnum,
	ToolkitsOptionsStringsEnum,
	QmuErrNameEnum,
	QmuInNameEnum,
	QmuOutNameEnum,
	RegularEnum,
	ScaledEnum,
	SeparateEnum,
	SsetEnum,
	VerboseEnum,
	/*}}}*/
	/*Interpolation {{{*/
	TriangleInterpEnum,
	BilinearInterpEnum,
	NearestInterpEnum,
	/*}}}*/
	/*Coordinate Systems{{{*/
	XYEnum,
	XYZEnum,
	/*}}}*/
	/*Toolkits{{{*/
	DenseEnum,
	MpiDenseEnum,
	MpiSparseEnum,
	SeqEnum,
	MpiEnum,
	MumpsEnum,
	GslEnum,
	/*}}}*/
	/*Options{{{*/
	OptionEnum,
	GenericOptionEnum,
	OptionCellEnum,
	OptionStructEnum,
	/*}}}*/
	/*Rheology law (move to Material) {{{*/
	CuffeyEnum,
	PatersonEnum,
	ArrheniusEnum,
	LliboutryDuvalEnum,
	/*}}}*/
	/*Levelset related enums (will be moved to appropriate place when finished){{{*/
	TransientIslevelsetEnum,
	ExtrapolationVariableEnum,
	IceMaskNodeActivationEnum,
	LevelsetfunctionSlopeXEnum,
	LevelsetfunctionSlopeYEnum,
	LevelsetfunctionPicardEnum,
	/*}}}*/
	/*Sea Ice {{{*/
	SeaiceatmEnum,
	SeaiceoceanEnum,
	SeaiceThicknessEnum,
	SeaiceConcentrationEnum,
	SeaiceMinConcentrationEnum,
	SeaiceMinThicknessEnum,
	SeaiceMaxThicknessEnum,
	SeaiceSpcvxEnum,
	SeaiceSpcvyEnum,
	SeaiceCoriolisFactorEnum,
	BasalforcingsRhoOceanEnum,
	BasalforcingsOceanCoefEnum,
	BasalforcingsOceanLinDragCoefEnum,
	BasalforcingsOceanQuadDragCoefEnum,
	BasalforcingsOceanTurningAngleEnum,
	BasalforcingsOceanSshEnum,
	BasalforcingsOceanVxEnum,
	BasalforcingsOceanVyEnum,
	SurfaceforcingsRhoAirEnum,
	SurfaceforcingsAirCoefEnum,
	SurfaceforcingsAirLinDragCoefEnum,
	SurfaceforcingsAirQuadDragCoefEnum,
	SurfaceforcingsWindVxEnum,
	SurfaceforcingsWindVyEnum,
	MatseaiceEnum,
	MaterialsPoissonEnum,
	MaterialsYoungModulusEnum,
	MaterialsTimeRelaxationStressEnum,
	MaterialsTimeRelaxationDamageEnum,
	MaterialsRidgingExponentEnum,
	MaterialsCohesionEnum,
	MaterialsInternalFrictionCoefEnum,
	MaterialsCompressionCoefEnum,
	MaterialsTractionCoefEnum,
	VxStarEnum,
	VyStarEnum,
	StressTensorPredictorxxEnum,
	StressTensorPredictoryyEnum,
	StressTensorPredictorxyEnum,
	/*}}}*/
	MaximumNumberOfDefinitionsEnum
};

#endif
