/*!\file: CreateParameters.cpp
 * \brief general driver for creating parameters dataset
 */ 

#undef __FUNCT__ 
#define __FUNCT__ "CreateParameters"

#include "../DataSet/DataSet.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../MeshPartitionx/MeshPartitionx.h"
#include "./IoModel.h"

void CreateParameters(DataSet** pparameters,IoModel* iomodel,ConstDataHandle iomodel_handle){
	
	int i;
	
	DataSet* parameters = NULL;
	Param*   param = NULL;
	int      count=1;
	int      numberofdofspernode;
	int      dim;


	/*Initialize dataset: */
	parameters   = new DataSet(ParametersEnum());
	
	//analysis and subanalysis
	count++;
	param= new Param(count,"analysis_type",INTEGER);
	param->SetInteger(iomodel->analysis_type);
	parameters->AddObject(param);

	count++;
	param= new Param(count,"sub_analysis_type",INTEGER);
	param->SetInteger(iomodel->sub_analysis_type);
	parameters->AddObject(param);

	//dimension 2d or 3d:
	if (strcmp(iomodel->meshtype,"2d")==0)dim=2;
	else dim=3;

	count++;
	param= new Param(count,"dim",INTEGER);
	param->SetInteger(dim);
	parameters->AddObject(param);

	//elements types
	count++;
	param= new Param(count,"ishutter",INTEGER);
	param->SetInteger(iomodel->ishutter);
	parameters->AddObject(param);

	count++;
	param= new Param(count,"ismacayealpattyn",INTEGER);
	param->SetInteger(iomodel->ismacayealpattyn);
	parameters->AddObject(param);


	count++;
	param= new Param(count,"isstokes",INTEGER);
	param->SetInteger(iomodel->isstokes);
	parameters->AddObject(param);

	//control: thermal static
	count++;
	param= new Param(count,"steadystate",INTEGER);
	param->SetInteger(iomodel->steadystate);
	parameters->AddObject(param);

	/*debug: */
	param= new Param(count,"debug",INTEGER);
	param->SetInteger(iomodel->debug);
	parameters->AddObject(param);

	/*eps_res: */
	count++;
	param= new Param(count,"eps_res",DOUBLE);
	param->SetDouble(iomodel->eps_res);
	parameters->AddObject(param);

	/*eps_rel: */
	count++;
	param= new Param(count,"eps_rel",DOUBLE);
	param->SetDouble(iomodel->eps_rel);
	parameters->AddObject(param);

	/*eps_abs: */
	count++;
	param= new Param(count,"eps_abs",DOUBLE);
	param->SetDouble(iomodel->eps_abs);
	parameters->AddObject(param);

	/*yts: */
	count++;
	param= new Param(count,"yts",DOUBLE);
	param->SetDouble(iomodel->yts);
	parameters->AddObject(param);

	/*dt: */
	count++;
	param= new Param(count,"dt",DOUBLE);
	param->SetDouble(iomodel->dt);
	parameters->AddObject(param);

	/*ndt: */
	count++;
	param= new Param(count,"ndt",DOUBLE);
	param->SetDouble(iomodel->ndt);
	parameters->AddObject(param);

	/*penalty_offset: */
	count++;
	param= new Param(count,"penalty_offset",DOUBLE);
	param->SetDouble(iomodel->penalty_offset);
	parameters->AddObject(param);

	/*sparsity: */
	count++;
	param= new Param(count,"sparsity",DOUBLE);
	param->SetDouble(iomodel->sparsity);
	parameters->AddObject(param);

	/*lowmem: */
	count++;
	param= new Param(count,"lowmem",INTEGER);
	param->SetInteger(iomodel->lowmem);
	parameters->AddObject(param);

	/*connectivity: */
	count++;
	param= new Param(count,"connectivity",INTEGER);
	param->SetInteger(iomodel->connectivity);
	parameters->AddObject(param);

	/*beta: */
	count++;
	param= new Param(count,"beta",DOUBLE);
	param->SetDouble(iomodel->beta);
	parameters->AddObject(param);

	/*meltingpoint: */
	count++;
	param= new Param(count,"meltingpoint",DOUBLE);
	param->SetDouble(iomodel->meltingpoint);
	parameters->AddObject(param);

	/*latentheat: */
	count++;
	param= new Param(count,"latentheat",DOUBLE);
	param->SetDouble(iomodel->latentheat);
	parameters->AddObject(param);

	/*heatcapacity: */
	count++;
	param= new Param(count,"heatcapacity",DOUBLE);
	param->SetDouble(iomodel->heatcapacity);
	parameters->AddObject(param);

	/*penalty_melting: */
	count++;
	param= new Param(count,"penalty_melting",DOUBLE);
	param->SetDouble(iomodel->penalty_melting);
	parameters->AddObject(param);

	/*min_thermal_constraints: */
	count++;
	param= new Param(count,"min_thermal_constraints",INTEGER);
	param->SetInteger(iomodel->min_thermal_constraints);
	parameters->AddObject(param);

	/*stokesreconditioning: */
	count++;
	param= new Param(count,"stokesreconditioning",DOUBLE);
	param->SetDouble(iomodel->stokesreconditioning);
	parameters->AddObject(param);

	/*waitonlock: */
	count++;
	param= new Param(count,"waitonlock",INTEGER);
	param->SetInteger(iomodel->waitonlock);
	parameters->AddObject(param);

	/*solverstring: */
	count++;
	param= new Param(count,"solverstring",STRING);
	param->SetString(iomodel->solverstring);
	parameters->AddObject(param);

	/*plot: */
	count++;
	param= new Param(count,"plot",INTEGER);
	param->SetInteger(iomodel->plot);
	parameters->AddObject(param);

	/*numberofgrids: */
	count++;
	param= new Param(count,"numberofnodes",INTEGER);
	param->SetInteger(iomodel->numberofnodes);
	parameters->AddObject(param);

	/*Deal with numberofdofspernode: */
	DistributeNumDofs(&numberofdofspernode,iomodel->analysis_type,iomodel->sub_analysis_type);

	count++;
	param= new Param(count,"numberofdofspernode",INTEGER);
	param->SetInteger(numberofdofspernode);
	parameters->AddObject(param)
		;
	/*numrifts: */
	IoModelFetchData((void**)&iomodel->riftinfo,&iomodel->numrifts,NULL,iomodel_handle,"riftinfo","Matrix","Mat");
	count++;
	param= new Param(count,"numrifts",INTEGER);
	param->SetInteger(iomodel->numrifts);
	parameters->AddObject(param);
	xfree((void**)&iomodel->riftinfo); 
	
	/*All our datasets are already ordered by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */
	parameters->Presort();

	/*Assign output pointer: */
	*pparameters=parameters;
}
