function fields=testsgetfields(mdtype,string),
%TESTSGETfields - build the fields to be checked from a string
%
%   This routine is used by nightly runs (runme.m and updatearchive.m).
%   for an input string 'prognostic', it will output 'cielo'
%
%   Usage:
%      fields=testsgetfields(mdtype,string)
%
%   Example:
%      fields=testsgetfields(md.type,'diagnostic')
%
%   See also: TESTSGETANALYSIS, TESTGETPACKAGE

if strcmpi(string,'diagnostic'),
	if strcmpi(mdtype,'3d')
		fields={'diagnostic.vy','diagnostic.vz'};
	else
		fields={'diagnostic.vel'};
	end

elseif strcmpi(string,'thermalsteady'),
	fields={'thermal.temperature','thermal.melting'};

elseif strcmpi(string,'thermaltransient'),
	fields={'thermal(end).temperature','thermal(end).melting'};

elseif strcmpi(string,'prognostic'),
	fields={'prognostic.thickness'};

elseif strcmpi(string,'transient'), 
	if strcmpi(mdtype,'3d')
		fields={'transient(end).vel','transient(end).pressure','transient(end).temperature','transient(end).melting','transient(end).thickness','transient(end).surface','transient(end).bed'};
	else
		fields={'transient(end).vel','transient(end).thickness','transient(end).surface','transient(end).bed'};
	end

elseif strcmpi(string,'steadystate'), 
	fields={'steadystate.vel','steadystate.pressure','steadystate.temperature'};

elseif strcmpi(string,'control'),
	fields={'control.vel','control.J','control.parameter'};

else
	error(['testsgetfields error message: solution '  string ' not supported yet']);
end
