function md=tres(md,string)
%TRES - transfer results results to corresponding model fields. 
%
%    Usage: md=tres(md,string)
%
%
%    Example: md=tres(md,'diagnostic');
%             md=tres(md,'control');

if strcmpi(string,'diagnostic'),
	md.vx=md.results.diagnostic.vx;
	md.vy=md.results.diagnostic.vy;
	md.vel=md.results.diagnostic.vel;
	md.pressure=md.results.diagnostic.pressure;
	if md.numrifts,
		md.riftproperties=md.results.diagnostic.riftproperties;
	end
elseif strcmpi(string,'steadystate'),
	md.vx=md.results.steadystate.vx;
	md.vy=md.results.steadystate.vy;
	md.vel=md.results.steadystate.vel;
	md.pressure=md.results.steadystate.pressure;
	md.temperature=md.results.steadystate.temperature;
	md.melting=md.results.steadystate.melting;
elseif strcmpi(string,'thermal'),
	md.temperature=md.results.steadystate.temperature;
	md.melting=md.results.steadystate.melting;
else 
	error(['tres error message: analysis ' string ' not supported yet!']);
end
