/*! \file EnthalpyAnalysis.h 
 *  \brief: header file for generic external result object
 */

#ifndef _EnthalpyAnalysis_
#define _EnthalpyAnalysis_

/*Headers*/
#include "./Analysis.h"
#include "../classes/classes.h"

class EnthalpyAnalysis: public Analysis{

	public:
		/*Model processing*/
		int  DofsPerNode(int** doflist,int domaintype,int approximation);
		void UpdateParameters(Parameters* parameters,IoModel* iomodel,int solution_enum,int analysis_enum);
		void UpdateElements(Elements* elements,IoModel* iomodel,int analysis_counter,int analysis_type);
		void CreateNodes(Nodes* nodes,IoModel* iomodel);
		void CreateConstraints(Constraints* constraints,IoModel* iomodel);
		void CreateLoads(Loads* loads, IoModel* iomodel);

		/*Finite element Analysis*/
		void           Core(FemModel* femmodel);
		ElementVector* CreateDVector(Element* element);
		ElementMatrix* CreateJacobianMatrix(Element* element);
		ElementMatrix* CreateKMatrix(Element* element);
		ElementMatrix* CreateKMatrixVolume(Element* element);
		ElementMatrix* CreateKMatrixShelf(Element* element);
		ElementVector* CreatePVector(Element* element);
		ElementVector* CreatePVectorVolume(Element* element);
		ElementVector* CreatePVectorSheet(Element* element);
		ElementVector* CreatePVectorShelf(Element* element);
		void GetBConduct(IssmDouble* B,Element* element,IssmDouble* xyz_list,Gauss* gauss);
		void GetBAdvec(IssmDouble* B,Element* element,IssmDouble* xyz_list,Gauss* gauss);
		void GetBAdvecprime(IssmDouble* B,Element* element,IssmDouble* xyz_list,Gauss* gauss);
		void GetSolutionFromInputs(Vector<IssmDouble>* solution,Element* element);
		void GradientJ(Vector<IssmDouble>* gradient,Element* element,int control_type,int control_index);
		void InputUpdateFromSolution(IssmDouble* solution,Element* element);
		void UpdateConstraints(FemModel* femmodel);

		/*Modules*/
		static void PostProcessing(FemModel* femmodel);
		static void ComputeBasalMeltingrate(FemModel* femmodel);
		static void ComputeBasalMeltingrate(Element* element);
		static void DrainWaterfraction(FemModel* femmodel);
		static void DrainWaterfractionIcecolumn(Element* element);
		static void DrainWaterfraction(Element* element, IssmDouble* pdrainrate_element);
		static void UpdateBasalConstraints(FemModel* femmodel);
		static void UpdateBasalConstraints(Element* element);
		static void UpdateBasalConstraintsTransient(Element* element);
		static void UpdateBasalConstraintsSteadystate(Element* element);
		static int GetThermalBasalCondition(Element* element, IssmDouble enthalpy, IssmDouble enthalpy_up, IssmDouble pressure, IssmDouble pressure_up, IssmDouble watercolumn, IssmDouble meltingrate);
		static IssmDouble GetWetIceConductivity(Element* element, IssmDouble enthalpy, IssmDouble pressure);


		/*Intermediaries*/
		static IssmDouble EnthalpyDiffusionParameter(Element* element,IssmDouble enthalpy,IssmDouble pressure);
		static IssmDouble EnthalpyDiffusionParameterVolume(Element* element,int enthalpy_enum);
		static IssmDouble PureIceEnthalpy(Element* element,IssmDouble pressure);
		static IssmDouble TMeltingPoint(Element* element,IssmDouble pressure);
};
#endif
