import numpy
def exportVTK(filename,model,options):
    '''
    vtk export
    function exportVTK(filename,model)
    creates a directory with the vtk files for displays in paraview
    (only work for triangle and wedges based on their number of nodes)
    
    Give only the results for nw but could be extended to geometry, mask... 
    
    input: filename   destination 
    (string)
    ------------------------------------------------------------------
    model      this is md 
    ------------------------------------------------------------------
    By default only the results are exported, you can add whichever
    field you need as a string:
    add 'geometry' to export md.geometry
    
    Basile de Fleurian:
    '''

[path,name,ext]=fileparts(filename)
separator=filesep
mkdir(filename)

#get the element related variables
if model.mesh.shape[0]==2:
    points=[model.mesh.x model.mesh.y zeros(model.mesh.numberofvertices,1)];
else:
    points=[model.mesh.x model.mesh.y model.mesh.z]

[num_of_points,dim]=numpy.size(points)
[num_of_elt]=numpy.size(model.mesh.elements,1)
[point_per_elt]=numpy.size(model.mesh.elements,2)

#Select the type of element function of the number of nodes per elements
if point_per_elt==3:
    celltype=5 #triangles
elif point_per_elt==6:
    celltype=13 #wedges
else:
    error('Your Element definition is not taken into account \n')
    
#this is the result structure
res_struct=model.results
if (len(fields(res_struct))>0):
    #Getting all the solutions of the model
    solnames=fields(res_struct)
    num_of_sols=numpy.length(solnames)
    num_of_timesteps=1
    #%building solutionstructure 
    for solution in num_of_sols:
        sol_struct{i}=res_struct.(solnames{i});
        #looking for multiple time steps
        if(numpy.size(sol_struct{i},2)>num_of_timesteps):
            num_of_timesteps=numpy.size(sol_struct{i},2);

else:
    num_of_timesteps=1

for step in num_of_timesteps:
    
    timestep=step
    
    fid = open(strcat(path,filesep,name,filesep,name,'.vtk',int2str(timestep),'.vtk'),'w+')
    fid.write('# vtk DataFile Version 2.0 \n')
    fid.write('Data for run %s \n' % model.miscellaneous.name)
    fid.write('ASCII \n')
    fid.write('DATASET UNSTRUCTURED_GRID \n')
	
    fid.write(fid,'POINTS %d float\n',num_of_points)
    if(dim==3):
        s='%f %f %f \n'
    elif(dim==2):
        s='%f %f \n'
    
    P=[points zeros(num_of_points,3-dim)]
    fid.write(fid,s,transpose de P)
	
    fid.write('CELLS %d %d\n' % num_of_elt % num_of_elt*(point_per_elt+1))
    s='%d'
    for j=1:point_per_elt:
        s=horzcat(s,{' %d'})
        
    s=cell2mat(horzcat(s,{'\n'}))
    fid.write(fid,s,[(point_per_elt)*ones(num_of_elt,1) model.mesh.elements-1]transpose)
    
    fid.write(fid,'CELL_TYPES %d\n',num_of_elt)
    s='%d\n'
    fid.write(fid,s,celltype*ones(num_of_elt,1))
    fid.write(fid,'POINT_DATA %s \n',num2str(num_of_points))
    
    #loop over the different solution structures
    if 'num_of_sols' in locals():
        for j=1:num_of_sols:
            #dealing with results on different timesteps
            if(numpy.size(sol_struct{j},2)>timestep):
                timestep = step
            else:
                timestep = numpy.size(sol_struct{j},2)
                
            #getting the number of fields in the solution
            fieldnames=fields(sol_struct{j}(timestep))
            num_of_fields=numpy.length(fieldnames)
		
            #check which field is a real result and print
            for k=1:num_of_fields:
                if ((numel(sol_struct{j}(timestep).(fieldnames{k})))==num_of_points):
                    #paraview does not like NaN, replacing
                    nanval=find(isnan(sol_struct{j}(timestep).(fieldnames{k})))
                    sol_struct{j}(timestep).(fieldnames{k})(nanval)=-9999
                    #also checking for verry small value that mess up
                    smallval=(abs(sol_struct{j}(timestep).(fieldnames{k}))<1.0e-20)
                    sol_struct{j}(timestep).(fieldnames{k})(smallval)=0.0
                    fid.write('SCALARS %s float 1 \n' % fieldnames{k})
                    fid.write('LOOKUP_TABLE default\n')
                    s='%e\n'
                    fid.write(s % sol_struct{j}(timestep).(fieldnames{k}))
                    
    #loop on arguments, if something other than result is asked, do
    #it now
    for j= 1:nargin-2:
        res_struct=model.(varargin{j})
        fieldnames=fields(res_struct)
        num_of_fields=numpy.length(fieldnames)
        for k=1:num_of_fields:
            if ((numel(res_struct.(fieldnames{k})))==num_of_points):
                #paraview does not like NaN, replacing
                nanval=find(isnan(res_struct.(fieldnames{k})))
                res_struct.(fieldnames{k})(nanval)=-9999
                #also checking for verry small value that mess up
                smallval=(abs(res_struct.(fieldnames{k}))<1.0e-20)
                res_struct.(fieldnames{k})(smallval)=0.0
                fid.write(fid,'SCALARS %s float 1 \n',fieldnames{k})
                fid.write(fid,'LOOKUP_TABLE default\n')
                s='%e\n'
                fid.write(fid,s,res_struct.(fieldnames{k}))
    fid.close();
