%FRICTIONWEERTMAN class definition
%
%   Usage:
%      frictionweertman=frictionhydro();

classdef frictionhydro
	properties (SetAccess=public) 
		q  = NaN;
		C  = NaN;
		As = NaN;
	end
	methods
		function obj = frictionhydro(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{

			%Early return
			if ~ismember(StressbalanceAnalysisEnum(),analyses) & ~ismember(ThermalAnalysisEnum(),analyses), return; end
			md = checkfield(md,'fieldname','frictionhydro.q','NaN',1,'size',[md.mesh.numberofelements 1]);
			md = checkfield(md,'fieldname','frictionhydro.C','NaN',1,'size',[md.mesh.numberofelements 1]);
			md = checkfield(md,'fieldname','frictionhydro.As','NaN',1,'size',[md.mesh.numberofelements 1]);
		end % }}}
		function disp(obj) % {{{
			disp(sprintf('Effective Pressure based friction law described in Gagliardini 2007')
			fielddisplay(obj,'q','friction law exponent q>=1');
			fielddisplay(obj,'C','friction law max value [SI]');
			fielddisplay(obj,'As','Sliding Parameter without cavitation [m Pa^-n s^-1]');
		end % }}}
		function marshall(obj,md,fid) % {{{
			WriteData(fid,'enum',FrictionLawEnum,'data',3,'format','Integer');
			WriteData(fid,'class','friction','object',obj,'fieldname','q','format','DoubleMat','mattype',2);
			WriteData(fid,'class','friction','object',obj,'fieldname','C','format','DoubleMat','mattype',2);
			WriteData(fid,'class','friction','object',obj,'fieldname','As','format','DoubleMat','mattype',2);
		end % }}}
	end
end
