/*!\file: seaice_core.cpp
 * \brief: core of the seaice solution 
 */ 

#include "./cores.h"
#include "../toolkits/toolkits.h"
#include "../classes/classes.h"
#include "../shared/shared.h"
#include "../modules/modules.h"
#include "../solutionsequences/solutionsequences.h"

void seaice_core(FemModel* femmodel){

	/*parameters: */
	bool save_results;

	/*recover parameters: */
	femmodel->parameters->FindParam(&save_results,SaveResultsEnum);

	/*Launch solution sequence for the only analysis we are interested in*/
	femmodel->SetCurrentConfiguration(SeaiceAnalysisEnum);
	SeaiceAnalysis* analysis = new SeaiceAnalysis();
	analysis->UpdateDamageAndStress(femmodel);
	solutionsequence_linear(femmodel);

	if(save_results){
		if(VerboseSolution()) _printf0_("   saving results\n");
		int outputs[6] = {VxEnum,VyEnum,VelEnum,SeaiceConcentrationEnum,SeaiceThicknessEnum,DamageEnum};
		femmodel->RequestedOutputsx(&femmodel->results,&outputs[0],6);
	}

}
