%CONSTANTS class definition
%
%   Usage:
%      constants=constants();

classdef constants
	properties (SetAccess=public) 
		g                    = 0.;
		omega                = 0.;
		yts                  = 0.;
		referencetemperature = 0.;
	end
	methods
        function createxml(obj,fid) % {{{
            fprintf(fid, '\n\n');
            fprintf(fid, '%s\n', '<!-- constants -->');
			 fprintf(fid,'%s%s%s%s%s\n%s\n%s\n%s\n','<parameter key ="g" type="',class(obj.g),'" default="',num2str(obj.g),'">','     <section name="constants" />','     <help> gravitational acceleration [m/s^2] </help>','</parameter>');
             fprintf(fid,'%s%s%s%s%s\n%s\n%s\n%s\n','<parameter key ="yts" type="',class(obj.yts),'" default="',num2str(obj.yts),'">','     <section name="constants" />','     <help> number of seconds in a year [s/yr] </help>','</parameter>');
             fprintf(fid,'%s%s%s%s%s\n%s\n%s\n','<parameter key ="referencetemperature" type="',class(obj.referencetemperature),'" default="',num2str(obj.referencetemperature),'">','     <section name="constants" />','     <help> reference temperature used in the enthalpy model [K] </help>','</parameter>');
		end % }}}
		function obj = constants(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%acceleration due to gravity (m/s^2)
			obj.g=9.81;

			%Earth's rotation speed 
			obj.omega = 7.292*1e-5;

			%converstion from year to seconds
			obj.yts=365*24*3600;

			%the reference temperature for enthalpy model (cf Aschwanden)
			obj.referencetemperature=223.15;

		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{

			md = checkfield(md,'fieldname','constants.g','>=',0,'size',[1 1]); %We allow 0 for validation tests
			md = checkfield(md,'fieldname','constants.omega','>=',0,'size',[1 1]);
			md = checkfield(md,'fieldname','constants.yts','>',0,'size',[1 1]);
			md = checkfield(md,'fieldname','constants.referencetemperature','size',[1 1]);

		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   constants parameters:'));

			fielddisplay(obj,'g','gravitational acceleration [m/s^2]');
			fielddisplay(obj,'omega','angular velocity of Earth [rad/s]');
			fielddisplay(obj,'yts','number of seconds in a year [s/yr]');
			fielddisplay(obj,'referencetemperature','reference temperature used in the enthalpy model [K]');

		end % }}}
		function marshall(obj,md,fid) % {{{
			WriteData(fid,'object',obj,'fieldname','g','format','Double');
			WriteData(fid,'object',obj,'fieldname','omega','format','Double');
			WriteData(fid,'object',obj,'fieldname','yts','format','Double');
			WriteData(fid,'object',obj,'fieldname','referencetemperature','format','Double');
		end % }}}
	end
end
