%SEAICE class definition
%
%   Usage:
%      seaice=seaice();

classdef seaice
	properties (SetAccess=public) 
		min_concentration = 0.;
		min_thickness     = 0.;
		max_thickness     = 0.;
		spcvx             = NaN;
		spcvy             = NaN;
		coriolis_factor   = NaN;
	end
	methods
		function obj = seaice(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
					return;
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{
			if solution~=SeaiceSolutionEnum(), return; end
			md = checkfield(md,'fieldname','seaice.min_concentration','NaN',1,'>=',0,'numel',1);
			md = checkfield(md,'fieldname','seaice.min_thickness','NaN',1,'>=',0,'numel',1);
			md = checkfield(md,'fieldname','seaice.max_thickness','NaN',1,'>',0,'numel',1);
			md = checkfield(md,'fieldname','seaice.spcvx','size',[md.mesh.numberofvertices 1]);
			md = checkfield(md,'fieldname','seaice.spcvy','size',[md.mesh.numberofvertices 1]);
			md = checkfield(md,'fieldname','seaice.coriolis_factor','size',[md.mesh.numberofelements 1],'NaN',1,'>=',0);
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%Minimum ice concentration allowed in the simulation
			obj.min_concentration=0.;

			%Minimum ice thickness allowed in the simulation
			obj.min_thickness=0.;

			%Maxmimum ice thickness allowed in the simulation
			obj.max_thickness=25.;

		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   seaice parameters:'));
			fielddisplay(obj,'min_concentration','minimum ice concentration allowed in the simulation [no unit]');
			fielddisplay(obj,'min_thickness','minimum ice thickness allowed in the simulation [m]');
			fielddisplay(obj,'max_thickness','maximum ice thickness allowed in the simulation [m]');
			fielddisplay(obj,'spcvx','x-axis velocity constraint (NaN means no constraint) [m/s]');
			fielddisplay(obj,'spcvy','y-axis velocity constraint (NaN means no constraint) [m/s]');
			fielddisplay(obj,'coriolis_factor','factor applied to Coriolis forces (latitude dependent)');
		end % }}}
		function marshall(obj,md,fid) % {{{
			WriteData(fid,'object',obj,'fieldname','min_concentration','format','Double');
			WriteData(fid,'object',obj,'fieldname','min_thickness','format','Double');
			WriteData(fid,'object',obj,'fieldname','max_thickness','format','Double');
			WriteData(fid,'object',obj,'fieldname','spcvx','format','DoubleMat','mattype',1);
			WriteData(fid,'object',obj,'fieldname','spcvy','format','DoubleMat','mattype',1);
			WriteData(fid,'object',obj,'fieldname','coriolis_factor','format','DoubleMat','mattype',2);
		end % }}}
	end
end
