/*!\file Matseaice.c
 * \brief: implementation of the Matseaice object
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./Matseaice.h"
#include "./Materials.h"
#include "../Inputs/Input.h"
#include "../Inputs/Inputs.h"
#include "../Inputs/TriaInput.h"
#include "../Inputs/PentaInput.h"
#include "../Inputs/ControlInput.h"
#include "../Elements/Element.h"
#include "../Elements/Tria.h"
#include "../Elements/Penta.h"
#include "../Params/Parameters.h"
#include "../Vertex.h"
#include "../Hook.h"
#include "../Node.h"
#include "../IoModel.h"
#include "../../shared/shared.h"

/*Matseaice constructors and destructor*/
Matseaice::Matseaice(){/*{{{*/
	this->helement=NULL;
	this->element=NULL;
	return;
}
/*}}}*/
Matseaice::Matseaice(int matseaice_mid,int index, IoModel* iomodel){/*{{{*/

	/*Intermediaries:*/
	int    matseaice_eid;

	/*Initialize id*/
	this->mid=matseaice_mid;

	/*Hooks: */
	matseaice_eid=index+1;
	this->helement=new Hook(&matseaice_eid,1);
	this->element=NULL;

	return;
}
/*}}}*/
Matseaice::~Matseaice(){/*{{{*/
	delete helement;
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
void Matseaice::Echo(void){/*{{{*/

	_printf_("Matseaice:\n");
	_printf_("   mid: " << mid << "\n");
	_printf_("   element:\n");
	helement->Echo();
}
/*}}}*/
void Matseaice::DeepEcho(void){/*{{{*/

	_printf_("Matseaice:\n");
	_printf_("   mid: " << mid << "\n");
	_printf_("   element:\n");
	helement->Echo();
}		
/*}}}*/
int  Matseaice::Id(void){ return mid; }/*{{{*/
/*}}}*/
int Matseaice::ObjectEnum(void){/*{{{*/

	return MatseaiceEnum;

}
/*}}}*/
Object* Matseaice::copy() {/*{{{*/

	/*Output*/
	Matseaice* matseaice=NULL;

	/*Initialize output*/
	matseaice=new Matseaice();

	/*copy fields: */
	matseaice->mid=this->mid;
	matseaice->helement=(Hook*)this->helement->copy();
	matseaice->element =(Element*)this->helement->delivers();

	return matseaice;
}
/*}}}*/
Material* Matseaice::copy2(Element* element_in) {/*{{{*/

	/*Output*/
	Matseaice* matseaice=NULL;

	/*Initialize output*/
	matseaice=new Matseaice();

	/*copy fields: */
	matseaice->mid=this->mid;
	matseaice->helement=(Hook*)this->helement->copy();
	matseaice->element =element_in;

	return matseaice;
}
/*}}}*/

/*Matseaice management*/
void  Matseaice::Configure(Elements* elementsin){/*{{{*/

	/*Take care of hooking up all objects for this element, ie links the objects in the hooks to their respective 
	 * datasets, using internal ids and offsets hidden in hooks: */
	helement->configure((DataSet*)elementsin);
	this->element  = (Element*)helement->delivers();
}
/*}}}*/
void  Matseaice::SetCurrentConfiguration(Elements* elementsin,Loads* loadsin,Nodes* nodesin,Vertices* verticesin,Materials* materialsin,Parameters* parametersin){/*{{{*/

}
/*}}}*/
void  Matseaice::ResetHooks(){/*{{{*/

	this->element=NULL;

	/*Get Element type*/
	this->helement->reset();

}
/*}}}*/
