%SEAICE class definition
%
%   Usage:
%      seaice=seaice();

classdef seaice
	properties (SetAccess=public) 
		thickness     = NaN;
		concentration = NaN;
		spcvx         = NaN;
		spcvy         = NaN;
	end
	methods
		function obj = seaice(varargin) % {{{
			switch nargin
				case 0
					return;
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{
			if solution~=SeaiceSolutionEnum(), return; end
			md = checkfield(md,'fieldname','seaice.thickness','size',[md.mesh.numberofelements 1],'NaN',1,'>=',0);
			md = checkfield(md,'fieldname','seaice.concentration','size',[md.mesh.numberofelements 1],'NaN',1,'>=',0);
			md = checkfield(md,'fieldname','seaice.spcvx','size',[md.mesh.numberofvertices 1]);
			md = checkfield(md,'fieldname','seaice.spcvy','size',[md.mesh.numberofvertices 1]);
		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   seaice parameters:'));
			fielddisplay(obj,'thickness','sea ice thickness [m]');
			fielddisplay(obj,'spcvx','x-axis velocity constraint (NaN means no constraint) [m/s]');
			fielddisplay(obj,'spcvy','y-axis velocity constraint (NaN means no constraint) [m/s]');
		end % }}}
		function marshall(obj,md,fid) % {{{
			WriteData(fid,'object',obj,'fieldname','thickness','format','DoubleMat','mattype',2);
			WriteData(fid,'object',obj,'fieldname','concentration','format','DoubleMat','mattype',2);
			WriteData(fid,'object',obj,'fieldname','spcvx','format','DoubleMat','mattype',1);
			WriteData(fid,'object',obj,'fieldname','spcvy','format','DoubleMat','mattype',1);
		end % }}}
	end
end
