%SEAICEINITIALIZATION class definition
%
%   Usage:
%      seaiceinitialization=seaiceinitialization();

classdef seaiceinitialization
	properties (SetAccess=public) 
		vx          = NaN;
		vy          = NaN;
		vx_coriolis = NaN;
		vy_coriolis = NaN;
	end
	methods
		function obj = seaiceinitialization(varargin) % {{{
			switch nargin
				case 0
					return;
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{
			md = checkfield(md,'fieldname','initialization.vx','NaN',1,'size',[md.mesh.numberofvertices 1]);
			md = checkfield(md,'fieldname','initialization.vy','NaN',1,'size',[md.mesh.numberofvertices 1]);
			md = checkfield(md,'fieldname','initialization.vx_coriolis','NaN',1,'size',[md.mesh.numberofvertices 1]);
			md = checkfield(md,'fieldname','initialization.vy_coriolis','NaN',1,'size',[md.mesh.numberofvertices 1]);
		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   initial field values:'));
			fielddisplay(obj,'vx','x component of the ice velocity [m/s]');
			fielddisplay(obj,'vy','y component of the ice velocity [m/s]');
			fielddisplay(obj,'vx_coriolis','x component of the ice velocity used to calculate coriolis forces [m/s]');
			fielddisplay(obj,'vy_coriolis','y component of the ice velocity used to calculate coriolis forces [m/s]');
		end % }}}
		function marshall(obj,md,fid) % {{{
			WriteData(fid,'data',obj.vx,'format','DoubleMat','mattype',1,'enum',VxEnum);
			WriteData(fid,'data',obj.vy,'format','DoubleMat','mattype',1,'enum',VyEnum);
			WriteData(fid,'data',obj.vx_coriolis,'format','DoubleMat','mattype',1,'enum',VxStarEnum);
			WriteData(fid,'data',obj.vy_coriolis,'format','DoubleMat','mattype',1,'enum',VyStarEnum);
		end % }}}
	end
end
