/*!\file: seaice_core.cpp
 * \brief: core of the seaice solution 
 */ 

#include "./cores.h"
#include "../toolkits/toolkits.h"
#include "../classes/classes.h"
#include "../shared/shared.h"
#include "../modules/modules.h"
#include "../solutionsequences/solutionsequences.h"

void seaice_core(FemModel* femmodel){

	/*parameters: */
	bool save_results;

	/*recover parameters: */
	femmodel->parameters->FindParam(&save_results,SaveResultsEnum);

	if(VerboseSolution()) _printf0_("call computational core:\n");
	femmodel->SetCurrentConfiguration(SeaiceAnalysisEnum);
	solutionsequence_linear(femmodel);

	if(save_results){
		if(VerboseSolution()) _printf0_("   saving results\n");
		int outputs[6] = {VxEnum,VyEnum,VelEnum,SeaiceConcentrationEnum,SeaiceThicknessEnum,MaterialsDamageEnum};
		femmodel->RequestedOutputsx(&femmodel->results,&outputs[0],6);
	}

}
