/*!\file Matseaice.h
 * \brief: header file for matice object
 */

#ifndef MATSEAICE_H_
#define MATSEAICE_H_

/*Headers:*/
/*{{{*/
#include "./Material.h"
#include "../Hook.h"
class IoModel;
class Elements;
class Element;
class Loads;
class Nodes;
class Vertices;
class Materials;
class Parameters;
/*}}}*/

class Matseaice: public Material{

	private: 
		int      mid;
		Hook    *helement;
		Element *element;

	public:
		/*Matseaice constructors, destructors: {{{*/
		Matseaice();
		Matseaice(int mid,int i, IoModel* iomodel);
		~Matseaice();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*Update virtual funictions definitions: {{{*/
		void  InputUpdateFromVector(IssmDouble* vector, int name, int type){_error_("not implemented");};
		void  InputUpdateFromMatrixDakota(IssmDouble* matrix, int nrow, int ncols, int name, int type){_error_("not implemented");};
		void  InputUpdateFromVectorDakota(IssmDouble* vector, int name, int type){_error_("not implemented");};
		void  InputUpdateFromConstant(IssmDouble constant, int name){_error_("not implemented");};
		void  InputUpdateFromConstant(int constant, int name){_error_("not implemented");};
		void  InputUpdateFromConstant(bool constant, int name){_error_("not implemented");};
		void  InputUpdateFromIoModel(int index, IoModel* iomodel){_error_("not implemented");};
		/*}}}*/
		/*Material virtual functions resolution: {{{*/
		void   Configure(Elements* elements);
		Material*  copy2(Element* element);
		void       SetCurrentConfiguration(Elements* elements,Loads* loads,Nodes* nodes,Vertices* vertices,Materials* materials,Parameters* parameters);
		void       GetViscosity(IssmDouble* pviscosity, IssmDouble eps_eff){_error_("not supported for this material");};
		void       GetViscosity_B(IssmDouble* pviscosity, IssmDouble eps_eff){_error_("not supported for this material");};
		void       GetViscosity_D(IssmDouble* pviscosity, IssmDouble eps_eff){_error_("not supported for this material");};
		void       GetViscosityBar(IssmDouble* pviscosity, IssmDouble eps_eff){_error_("not supported for this material");};
		void       GetViscosityComplement(IssmDouble* pviscosity_complement, IssmDouble* pepsilon){_error_("not supported for this material");};
		void       GetViscosityDComplement(IssmDouble*, IssmDouble*){_error_("not supported for this material");};
		void       GetViscosityDerivativeEpsSquare(IssmDouble* pmu_prime, IssmDouble* pepsilon){_error_("not supported for this material");};
		void       GetViscosity2dDerivativeEpsSquare(IssmDouble* pmu_prime, IssmDouble* pepsilon){_error_("not supported for this material");};
		IssmDouble GetA(){_error_("not supported for this material");};
		IssmDouble GetAbar(){_error_("not supported for this material");};
		IssmDouble GetB(){_error_("not supported for this material");};
		IssmDouble GetBbar(){_error_("not supported for this material");};
		IssmDouble GetD(){_error_("not supported for this material");};
		IssmDouble GetDbar(){_error_("not supported for this material");};
		IssmDouble GetN(){_error_("not supported for this material");};
		bool       IsDamage(){_error_("not supported for this material");};
		void       ResetHooks();
		/*}}}*/
};

#endif  /* _MATICE_H_ */
