/*! \file Model.h 
 *  \brief: header file for model object
 */

#ifndef _MODEL_H_
#define _MODEL_H_

struct FemModel;
class Model{

	private: 

		/*femmodels for each formulation:*/
		FemModel* diagnostichorizontal;
		FemModel* diagnosticvertical;
		FemModel* diagnosticstokes;
		FemModel* diagnostichutter;
		FemModel* slope;
		FemModel* prognostic;
		FemModel* thermal;
		FemModel* melting;
		
		/*active one: */
		FemModel* active;

	public:

		Model();
		~Model();

		void  Echo();
		void  DeepEcho();
		FemModel* DiagnosticHorizontal(void);
		FemModel* DiagnosticVertical(void);
		FemModel* DiagnosticStokes(void);
		FemModel* DiagnosticHutter(void);
		FemModel* Slope(void);
		FemModel* Prognostic(void);
		FemModel* Thermal(void);
		FemModel* Melting(void);
		FemModel* Active(void);
		void      SetActive(FemModel* femmodel);

};
#endif  /* _MODEL_H */
