/*!\file Model.c
 * \brief: implementation of the Model object
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./Model.h"
#include "stdio.h"

Model::Model(){
	return;
}

Model::~Model(){
	/*none of the FemModels are copied, just pointers -> no dynamic allocation.*/
	return;
}

#undef __FUNCT__
#define __FUNCT__ "Model::Echo"

void Model::Echo(void){

	printf("Model:\n");
	printf("   diagnostichorizontal: %p\n",diagnostichorizontal);
	printf("   diagnosticvertical: %p\n",diagnosticvertical);
	printf("   diagnosticstokes: %p\n",diagnosticstokes);
	printf("   diagnostichutter: %p\n",diagnostichutter);
	printf("   slope: %p\n",slope);
	printf("   prognostic: %p\n",prognostic);
	printf("   thermal: %p\n",thermal);
	printf("   melting: %p\n",melting);
	printf("   active: %p\n",active);

}
#undef __FUNCT__
#define __FUNCT__ "Model::DeepEcho"

void Model::DeepEcho(void){

	printf("Model:\n");
	printf("   diagnostichorizontal: %p\n",diagnostichorizontal);
	printf("   diagnosticvertical: %p\n",diagnosticvertical);
	printf("   diagnosticstokes: %p\n",diagnosticstokes);
	printf("   diagnostichutter: %p\n",diagnostichutter);
	printf("   slope: %p\n",slope);
	printf("   prognostic: %p\n",prognostic);
	printf("   thermal: %p\n",thermal);
	printf("   melting: %p\n",melting);
	printf("   active: %p\n",active);

}

FemModel* Model::DiagnosticHorizontal(void){
	return diagnostichorizontal;
}
FemModel* Model::DiagnosticVertical(void){
	return diagnosticvertical;
}
FemModel* Model::DiagnosticStokes(void){
	return diagnosticstokes;
}
FemModel* Model::DiagnosticHutter(void){
	return diagnostichutter;
}
FemModel* Model::Slope(void){
	return slope;
}
FemModel* Model::Prognostic(void){
	return prognostic;
}
FemModel* Model::Thermal(void){
	return thermal;
}
FemModel* Model::Melting(void){
	return melting;
}
FemModel* Model::Active(void){
	return active;
}
		
void      Model::SetActive(FemModel* femmodel){
	active=femmodel;
}
