/*!\file:  SpawnCore.cpp
 * \brief: branch into SpawnCoreMatlab and SpawnCoreParallel.
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#undef __FUNCT__ 
#define __FUNCT__ "SpawnCore"

#include "../objects/objects.h"
#include "../io/io.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../shared/shared.h"
#include "./Qmux.h"
#include "../include/macros.h"

void SpawnCore(double* responses, int numresponses, double* variables, char** variables_descriptors,int numvariables, void* model,void* inputs,int analysis_type,int sub_analysis_type,int counter){


	/*Branch into a serial SpawnCore and a parallel SpawnCore: */
	#ifdef _SERIAL_
	SpawnCoreSerial(responses, numresponses, variables, variables_descriptors,numvariables, (mxArray*)model, (mxArray*)inputs,analysis_type,sub_analysis_type,counter);
	#else
	SpawnCoreParallel(responses, numresponses, variables, variables_descriptors,numvariables, (Model*)model, (ParameterInputs*)inputs,analysis_type,sub_analysis_type,counter);
	#endif


}
