#!/bin/bash

#Check that test101 runs
cd $ISSM_DIR/test/NightlyRun
rm matlab.log
$MATLAB_DIR/bin/matlab -nojvm -nosplash -r "try, addpath $ISSM_DIR/bin $ISSM_DIR/lib; runme('id',101);exit; catch me,fprintf('%s',getReport(me)); exit; end" -logfile matlab.log

if [[ $(cat matlab.log | grep -c SUCCESS) -lt 10 ]]; then
	echo "test101 FAILED"
	exit 1;
else
	echo "test101 passed"
fi

#Package using the Package Maker from OSX, driven by command line.
tarball_name='issm-mac-static_build.tar.gz'
cd $ISSM_DIR

echo "Cleanup first" 
rm $tarball_name

echo "modify generic" 
cd $ISSM_DIR/bin
cat generic_static.m | sed -e "s/generic_static/generic/g" > generic.m

echo "Creating tarball: ${tarball_name}"
tar -czf $tarball_name ./bin ./lib ./test ./examples externalpackages/mpich/install/bin/mpiexec externalpackages/mpich/install/bin/hydra_pmi_proxy
ls
