#!/bin/bash

# Environment Variables
#
# ISSM_DIR and MATLAB_DIR must be set correctly.
# {{{
if [ "${ISSM_DIR}x" == "x" ]; then
   echo "ISSM_DIR is not set!" >&2
   exit 1;
elif [ -d ${ISSM_DIR} ]; then
   echo "ISSM_DIR: ${ISSM_DIR}"
else
   echo "ISSM_DIR: ${ISSM_DIR} does not exist!" >&2
   exit 1;
fi

if [ "${MATLAB_DIR}x" == "x" ]; then
   echo "MATLAB_DIR is not set!"
   exit 1;
elif [ -d ${MATLAB_DIR} ]; then
   echo "MATLAB_DIR: ${MATLAB_DIR}"
else
   echo "MATLAB_DIR: ${MATLAB_DIR} does not exist!" >&2
   exit 1;
fi
# }}}

cd $ISSM_DIR

# Externalpackages
# {{{
echo ""
echo "Installing external packages..."
echo ""

cd "$ISSM_DIR/externalpackages/matlab"
echo '---------------------------------'
echo "Linking Matlab"
echo '---------------------------------'
ln -s $MATLAB_DIR ./install

cd "$ISSM_DIR/externalpackages/cmake"
echo '---------------------------------'
echo "Installing CMAKE"
echo '---------------------------------'
./install.sh $1 &> /dev/null

if [ $? -ne 0 ]; then
   echo "FAILED TO INSTALL CMAKE!"
   exit 1;
fi

cd "$ISSM_DIR/externalpackages/autotools"
echo '---------------------------------'
echo "Installing Autotools"
echo '---------------------------------'
./install.sh &> /dev/null

if [ $? -ne 0 ]; then
   echo "FAILED TO INSTALL AUTOTOOLS!"
   exit 1;
fi

source $ISSM_DIR/etc/environment.sh

cd "$ISSM_DIR/externalpackages/triangle"
echo '---------------------------------'
echo "Installing Triangle"
echo '---------------------------------'
./install-macosx64.sh &> /dev/null

if [ $? -ne 0 ]; then
   echo "FAILED TO INSTALL TRIANGLE!"
   exit 1;
fi

cd "$ISSM_DIR/externalpackages/mpich"
echo '---------------------------------'
echo "Installing MPICH"
echo '---------------------------------'
./install-3.0-macosx64-static.sh $1 &> /dev/null

if [ $? -ne 0 ]; then
   echo "FAILED TO INSTALL MPICH!"
   exit 1;
fi

cd "$ISSM_DIR/externalpackages/petsc"
echo '---------------------------------'
echo "Installing PETSc"
echo '---------------------------------'
./install-3.5-macosx64-static.sh &> /dev/null

if [ $? -ne 0 ]; then
   echo "FAILED TO INSTALL PETSC!"
   exit 1;
fi
# }}}

source $ISSM_DIR/etc/environment.sh

cd $ISSM_DIR

echo "Aureconf..."
autoreconf -if &> /dev/null

if [ $? -ne 0 ]; then
   echo "FAILED TO AUTORECONF!"
   exit 1;
fi

echo "Configuring..."
$ISSM_DIR/configs/config-macosx64-static.sh &> /dev/null

if [ $? -ne 0 ]; then
   echo "FAILED TO CONFIGURE!"
   exit 1;
fi

echo "Building..."
if [ -z $1 ]; then
   make -j$1 &> /dev/null
else
   make &> /dev/null
fi

if [ $? -ne 0 ]; then
   echo "FAILED TO BUILD!"
   exit 1;
fi

echo "Installing..."
make install &> /dev/null

if [ $? -ne 0 ]; then
   echo "FAILED TO INSTALL!"
   exit 1;
fi
