#!/bin/sh

#petsc 3.2
#mpich 1.4

./configure \
	--prefix=$ISSM_DIR \
   --disable-static \
   --enable-standalone-executables \
   --enable-standalone-libraries \
	--with-matlab-dir=$MATLAB_DIR \
	--with-triangle-dir=$ISSM_DIR/externalpackages/triangle/install \
	--with-metis-dir=$ISSM_DIR/externalpackages/petsc/install \
	--with-petsc-dir=$ISSM_DIR/externalpackages/petsc/install  \
   --with-blas-lapack-dir=$ISSM_DIR/externalpackages/petsc/install \
	--with-mpi-include=$ISSM_DIR/externalpackages/mpich/install/include  \
	--with-mpi-libflags=" -L$ISSM_DIR/externalpackages/mpich/install/lib -lmpich -lpmpich" \
	--with-scalapack-dir=$ISSM_DIR/externalpackages/petsc/install \
	--with-mumps-dir=$ISSM_DIR/externalpackages/petsc/install \
   --with-fortran-lib="/usr/local/lib/libgfortran.a" \
   --enable-debugging \
	--with-numthreads=4
