/*!\file: CreateDataSets
 * \brief general driver for creating all datasets that make a finite element iomodel
 */ 

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#undef __FUNCT__ 
#define __FUNCT__ "CreateElementsNodesAndMaterials"

#include "./IoModel.h"
#include "../shared/shared.h"
#include "../EnumDefinitions/EnumDefinitions.h"


void CreateDataSets(DataSet** pelements,DataSet** pnodes, DataSet** pmaterials, DataSet** pconstraints, DataSet** ploads,DataSet** pparameters,IoModel* iomodel,ConstDataHandle iomodel_handle){


	/*create parameters common to all solutions: */
	CreateParameters(pparameters,iomodel,iomodel_handle);
	CreateParametersQmu(pparameters,iomodel,iomodel_handle);

	/*This is just a high level driver: */
	if (iomodel->analysis_type==ControlAnalysisEnum()){

		if (iomodel->sub_analysis_type==HorizAnalysisEnum()){

			CreateElementsNodesAndMaterialsDiagnosticHoriz(pelements,pnodes,pmaterials, iomodel,iomodel_handle);
			CreateConstraintsDiagnosticHoriz(pconstraints,iomodel,iomodel_handle);
			CreateLoadsDiagnosticHoriz(ploads,iomodel,iomodel_handle);
			CreateParametersControl(pparameters,iomodel,iomodel_handle);

		}
		else if (iomodel->sub_analysis_type==VertAnalysisEnum()){

			CreateElementsNodesAndMaterialsDiagnosticVert(pelements,pnodes,pmaterials, iomodel,iomodel_handle);
			CreateConstraintsDiagnosticVert(pconstraints,iomodel,iomodel_handle);
			CreateLoadsDiagnosticVert(ploads,iomodel,iomodel_handle);

		}
		else if (iomodel->sub_analysis_type==StokesAnalysisEnum()){

			CreateElementsNodesAndMaterialsDiagnosticStokes(pelements,pnodes,pmaterials, iomodel,iomodel_handle);
			CreateConstraintsDiagnosticStokes(pconstraints,iomodel,iomodel_handle);
			CreateLoadsDiagnosticStokes(ploads,iomodel,iomodel_handle);
			CreateParametersControl(pparameters,iomodel,iomodel_handle);

		}
		else if (iomodel->sub_analysis_type==HutterAnalysisEnum()){

			CreateElementsNodesAndMaterialsDiagnosticHutter(pelements,pnodes,pmaterials, iomodel,iomodel_handle);
			CreateConstraintsDiagnosticHutter(pconstraints,iomodel,iomodel_handle);
			CreateLoadsDiagnosticHutter(ploads,iomodel,iomodel_handle);
			CreateParametersControl(pparameters,iomodel,iomodel_handle);

		}

	}
	else if (iomodel->analysis_type==DiagnosticAnalysisEnum()){

		if (iomodel->sub_analysis_type==HorizAnalysisEnum()){
			
			CreateElementsNodesAndMaterialsDiagnosticHoriz(pelements,pnodes,pmaterials, iomodel,iomodel_handle);
			CreateConstraintsDiagnosticHoriz(pconstraints,iomodel,iomodel_handle);
			CreateLoadsDiagnosticHoriz(ploads,iomodel,iomodel_handle);
			CreateParametersDiagnosticHoriz(pparameters,iomodel,iomodel_handle);
				
		}
		else if (iomodel->sub_analysis_type==VertAnalysisEnum()){
		
			CreateElementsNodesAndMaterialsDiagnosticVert(pelements,pnodes,pmaterials, iomodel,iomodel_handle);
			CreateConstraintsDiagnosticVert(pconstraints,iomodel,iomodel_handle);
			CreateLoadsDiagnosticVert(ploads,iomodel,iomodel_handle);
			
		}
		else if (iomodel->sub_analysis_type==StokesAnalysisEnum()){

			CreateElementsNodesAndMaterialsDiagnosticStokes(pelements,pnodes,pmaterials, iomodel,iomodel_handle);
			CreateConstraintsDiagnosticStokes(pconstraints,iomodel,iomodel_handle);
			CreateLoadsDiagnosticStokes(ploads,iomodel,iomodel_handle);
			
		}
		else if (iomodel->sub_analysis_type==HutterAnalysisEnum()){

			CreateElementsNodesAndMaterialsDiagnosticHutter(pelements,pnodes,pmaterials, iomodel,iomodel_handle);
			CreateConstraintsDiagnosticHutter(pconstraints,iomodel,iomodel_handle);
			CreateLoadsDiagnosticHutter(ploads,iomodel,iomodel_handle);
			
		}
	}
	else if (iomodel->analysis_type==SlopeComputeAnalysisEnum()){

		CreateElementsNodesAndMaterialsSlopeCompute(pelements,pnodes,pmaterials, iomodel,iomodel_handle);
		CreateConstraintsSlopeCompute(pconstraints,iomodel,iomodel_handle);
		CreateLoadsSlopeCompute(ploads,iomodel,iomodel_handle);
	
	}
	else if (iomodel->analysis_type==ThermalAnalysisEnum()){

		CreateElementsNodesAndMaterialsThermal(pelements,pnodes,pmaterials, iomodel,iomodel_handle);
		CreateConstraintsThermal(pconstraints,iomodel,iomodel_handle);
		CreateLoadsThermal(ploads,iomodel,iomodel_handle);
		CreateParametersThermal(pparameters,iomodel,iomodel_handle);
					
	}
	else if (iomodel->analysis_type==MeltingAnalysisEnum()){
			
		CreateElementsNodesAndMaterialsMelting(pelements,pnodes,pmaterials, iomodel,iomodel_handle);
		CreateConstraintsMelting(pconstraints,iomodel,iomodel_handle);
		CreateLoadsMelting(ploads,iomodel,iomodel_handle);
		CreateParametersMelting(pparameters,iomodel,iomodel_handle);
	}
	else if (iomodel->analysis_type==PrognosticAnalysisEnum()){

		CreateElementsNodesAndMaterialsPrognostic(pelements,pnodes,pmaterials, iomodel,iomodel_handle);
		CreateConstraintsPrognostic(pconstraints,iomodel,iomodel_handle);
		CreateLoadsPrognostic(ploads,iomodel,iomodel_handle);
		CreateParametersPrognostic(pparameters,iomodel,iomodel_handle);
					
	}
	else{
		throw ErrorException(__FUNCT__,exprintf("%s%i%s%i%s"," analysis_type: ",iomodel->analysis_type," sub_analysis_type: ",iomodel->sub_analysis_type," not supported yet!"));
	}
			
}
