#!/bin/bash
set -eu

#Some cleanup 
rm -rf install src triangle
mkdir install src ./src/m4

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.py 'http://issm.jpl.nasa.gov/files/externalpackages/triangle.zip' 'triangle.zip'

#Untar 
cd src
mkdir src
cp ../triangle.zip ./
unzip triangle.zip

rm ./makefile
mv ./*.c ./src
mv ./*.h ./src

cp ../configs/triangle-libtool.tar.gz ./
tar -xvf ./triangle-libtool.tar.gz

autoreconf -ivf
./configure --prefix="${ISSM_DIR}/externalpackages/triangle/install"

make 
make install
