#!/bin/bash
set -eu

#Some cleanup 
rm -rf install src triangle
mkdir install src

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.py 'http://issm.jpl.nasa.gov/files/externalpackages/triangle.zip' 'triangle.zip'

#Untar 
cd src
mkdir src
cp ../triangle.zip ./
unzip triangle.zip

mv ./*.c ./src
mv ./*.h ./src

cp ../configs/triangle-libtool.tar.gz ./
tar -xvf ./triangle-libtool.tar.gz

autoreconf -ivf
./configure.sh --prefix="${ISSM_DIR}/externalpackages/triangle/install"

make 
make install
